/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.googlelocations;

import com.google.maps.DirectionsApi;
import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.ImageResult;
import com.google.maps.StaticMapsApi;
import com.google.maps.StaticMapsRequest;
import com.google.maps.errors.ApiException;
import com.google.maps.model.DirectionsLeg;
import com.google.maps.model.DirectionsResult;
import com.google.maps.model.DirectionsRoute;
import com.google.maps.model.DirectionsStep;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import com.google.maps.model.Size;
import com.google.maps.model.TravelMode;
import com.touchcomp.basementorexceptions.exceptions.impl.google.ExceptionGoogle;
import com.touchcomp.basementortools.model.net.ProxyNet;
import com.touchcomp.basementortools.tools.downloadweb.ToolDownloadWeb;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.googlelocations.model.GoogleAddress;
import com.touchcomp.basementortools.tools.googlelocations.model.GoogleGeographicPosition;
import com.touchcomp.basementortools.tools.googlelocations.model.GoogleLtLn;
import com.touchcomp.basementortools.tools.googlelocations.model.GooglePointMap;
import com.touchcomp.basementortools.tools.googlelocations.model.GoogleRoute;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ToolGoogleLocations {
    private static final int ANGULO_DEFAULT = 90;

    public static GoogleGeographicPosition getGeographicPosition(String api, GoogleAddress address) throws ExceptionGoogle {
        return ToolGoogleLocations.getGeographicPosition(api, address, null);
    }

    public static GoogleGeographicPosition getGeographicPosition(String api, GoogleAddress address, ProxyNet proxy) throws ExceptionGoogle {
        String full = ToolGoogleLocations.toString(address);
        return ToolGoogleLocations.getGeographicPosition(api, full, proxy);
    }

    public static GoogleGeographicPosition getGeographicPosition(String api, String address) throws ExceptionGoogle {
        return ToolGoogleLocations.getGeographicPosition(api, address, null);
    }

    public static GoogleGeographicPosition getGeographicPosition(String api, String address, ProxyNet proxy) throws ExceptionGoogle {
        try {
            GeoApiContext context = ToolGoogleLocations.createContext(api, proxy);
            GeocodingResult[] results = (GeocodingResult[])GeocodingApi.geocode((GeoApiContext)context, (String)address).await();
            GoogleGeographicPosition result = new GoogleGeographicPosition();
            if (results.length > 0) {
                GeocodingResult ge = results[0];
                result.setDataLoaded(true);
                result.setOriginalAddress(address);
                result.setFormattedAddress(ge.formattedAddress);
                result.setPlaceID(ge.placeId);
                GoogleLtLn ltLn = new GoogleLtLn(ge.geometry.location.lat, ge.geometry.location.lng);
                result.setLongLat(ltLn);
            }
            return result;
        }
        catch (ApiException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle((Exception)((Object)ex), api);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle(ex);
        }
    }

    public static double getDistance(String api, GoogleAddress origin, GoogleAddress destination) throws ExceptionGoogle {
        return ToolGoogleLocations.getDistance(api, origin, destination, null);
    }

    public static double getDistance(String api, GoogleAddress origin, GoogleAddress destination, ProxyNet proxy) throws ExceptionGoogle {
        List<GoogleRoute> route = ToolGoogleLocations.getPathToGoToAdddress(api, ToolGoogleLocations.toString(origin), ToolGoogleLocations.toString(destination), proxy);
        if (route.size() > 0) {
            return route.get(0).getDistanciaKM();
        }
        return 0.0;
    }

    public static List<GoogleRoute> getPathToGoToAdddress(String api, GoogleAddress origin, GoogleAddress destination) throws ExceptionGoogle {
        return ToolGoogleLocations.getPathToGoToAdddress(api, ToolGoogleLocations.toString(origin), ToolGoogleLocations.toString(destination), null);
    }

    public static List<GoogleRoute> getPathToGoToAdddress(String api, GoogleAddress origin, GoogleAddress destination, ProxyNet proxy) throws ExceptionGoogle {
        return ToolGoogleLocations.getPathToGoToAdddress(api, ToolGoogleLocations.toString(origin), ToolGoogleLocations.toString(destination), proxy);
    }

    private static List<GoogleRoute> getPathToGoToAdddress(String api, String origin, String destination, ProxyNet proxy) throws ExceptionGoogle {
        try {
            GeoApiContext context = ToolGoogleLocations.createContext(api, proxy);
            DirectionsResult result = (DirectionsResult)DirectionsApi.newRequest((GeoApiContext)context).mode(TravelMode.DRIVING).origin(origin).destination(destination).await();
            LinkedList<GoogleRoute> routes = new LinkedList<GoogleRoute>();
            for (DirectionsRoute route : result.routes) {
                GoogleRoute gr = new GoogleRoute();
                gr.setDescricao(route.summary);
                double distancia = 0.0;
                for (DirectionsLeg leg : route.legs) {
                    GoogleRoute.GoogleLeg l = new GoogleRoute.GoogleLeg();
                    if (leg.arrivalTime != null) {
                        l.setArrivalTime(Date.from(leg.arrivalTime.toInstant()));
                    }
                    if (leg.departureTime != null) {
                        l.setDepartureTime(Date.from(leg.departureTime.toInstant()));
                    }
                    l.setDistanceMeters(leg.distance.inMeters);
                    l.setDistanceKM(ToolFormatter.arrredondarNumero((double)leg.distance.inMeters / 1000.0, 2));
                    l.setHours(ToolFormatter.arrredondarNumero((double)leg.duration.inSeconds / 3600.0, 2));
                    l.setSeconds(leg.duration.inSeconds);
                    l.setEndAddress(leg.endAddress);
                    l.setStartAddress(leg.startAddress);
                    l.setStartLocation(new GoogleLtLn(leg.startLocation.lat, leg.startLocation.lng));
                    l.setEndLocation(new GoogleLtLn(leg.startLocation.lat, leg.startLocation.lng));
                    gr.getLegs().add(l);
                    distancia += l.getDistanceKM();
                    for (DirectionsStep step : leg.steps) {
                        GoogleRoute.GoogleStep st = new GoogleRoute.GoogleStep();
                        st.setDistanceInKM(ToolFormatter.arrredondarNumero((double)step.distance.inMeters / 1000.0, 2));
                        st.setDistanceInMeters(step.distance.inMeters);
                        st.setDurationInSeconds(step.duration.inSeconds);
                        st.setDurationInHours(ToolFormatter.arrredondarNumero((double)step.duration.inSeconds / 3600.0, 2));
                        st.setEndLocation(new GoogleLtLn(step.endLocation.lat, step.endLocation.lng));
                        st.setStartLocation(new GoogleLtLn(step.startLocation.lat, step.startLocation.lng));
                        st.setHtmlInstructions(step.htmlInstructions);
                        l.getSteps().add(st);
                    }
                }
                gr.setDistanciaKM(distancia);
                routes.add(gr);
            }
            return routes;
        }
        catch (ApiException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle((Exception)((Object)ex), api);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle(ex);
        }
    }

    private static String toString(GoogleAddress address) {
        return address.getEndereco() + ", " + address.getNumero() + ", " + address.getBairro() + ", " + address.getCidade() + ", " + address.getUf();
    }

    public static byte[] getStaticMapPath(String api, int height, int witdh, int scale, GooglePointMap center, List<GooglePointMap> points) throws ExceptionGoogle {
        return ToolGoogleLocations.getStaticMapPath(api, height, witdh, scale, center, points, null);
    }

    public static byte[] getStaticMapPath(String api, int height, int witdh, int scale, GooglePointMap center, List<GooglePointMap> points, ProxyNet proxy) throws ExceptionGoogle {
        try {
            GeoApiContext context = ToolGoogleLocations.createContext(api, proxy);
            Size sizeG = new Size();
            sizeG.height = height;
            sizeG.width = witdh;
            StaticMapsRequest req = StaticMapsApi.newRequest((GeoApiContext)context, (Size)sizeG);
            if (center != null) {
                req.center(new LatLng(center.getLtLn().getLatitude(), center.getLtLn().getLongitude()));
            }
            StaticMapsRequest.Path path = new StaticMapsRequest.Path();
            for (GooglePointMap point : points) {
                path.addPoint(new LatLng(point.getLtLn().getLatitude(), point.getLtLn().getLongitude()));
            }
            req.path(path);
            req.zoom(scale);
            req.maptype(StaticMapsRequest.StaticMapType.roadmap);
            ImageResult result = (ImageResult)req.await();
            return result.imageData;
        }
        catch (ApiException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle((Exception)((Object)ex), api);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle(ex);
        }
    }

    public static byte[] streetView(GoogleLtLn ponto, int angulo, String api) throws ExceptionGoogle {
        String url = ToolGoogleLocations.getUrl(ponto.getLatitude(), ponto.getLongitude(), angulo, api);
        try {
            return ToolDownloadWeb.downloadFileToServerByteArrayHttps(url);
        }
        catch (MalformedURLException ex) {
            throw new ExceptionGoogle(ex, url);
        }
        catch (IOException ex) {
            throw new ExceptionGoogle(ex);
        }
    }

    public static byte[] streetView(GoogleLtLn ponto, String api) throws ExceptionGoogle {
        return ToolGoogleLocations.streetView(ponto, 90, api);
    }

    private static String getUrl(double latitude, double longitude, int angulo, String api) {
        StringBuilder sb = new StringBuilder();
        sb.append("https://maps.googleapis.com/maps/api/streetview?size=400x400");
        sb.append("&location=");
        sb.append(latitude);
        sb.append(",");
        sb.append(longitude);
        sb.append("&fov=90");
        sb.append("&heading=");
        sb.append(angulo);
        sb.append("&pitch=10&sensor=false");
        sb.append("&sensor=false");
        sb.append("&key=").append(api);
        return sb.toString();
    }

    public static byte[] getStaticMap(String api, int height, int witdh, int scale, GooglePointMap center, List<GooglePointMap> points) throws ExceptionGoogle {
        return ToolGoogleLocations.getStaticMap(api, height, witdh, scale, center, points, null);
    }

    public static byte[] getStaticMap(String api, int height, int witdh, int scale, GooglePointMap center, List<GooglePointMap> points, ProxyNet proxy) throws ExceptionGoogle {
        try {
            GeoApiContext context = ToolGoogleLocations.createContext(api, proxy);
            Size sizeG = new Size();
            sizeG.height = height;
            sizeG.width = witdh;
            StaticMapsRequest req = StaticMapsApi.newRequest((GeoApiContext)context, (Size)sizeG);
            if (center != null) {
                req.center(new LatLng(center.getLtLn().getLatitude(), center.getLtLn().getLongitude()));
            }
            StaticMapsRequest.Markers marker = new StaticMapsRequest.Markers();
            for (GooglePointMap point : points) {
                marker.addLocation(new LatLng(point.getLtLn().getLatitude(), point.getLtLn().getLongitude()));
                marker.label(point.getLabel() != null ? point.getLabel() : "A");
            }
            req.markers(marker);
            req.zoom(scale);
            req.maptype(StaticMapsRequest.StaticMapType.roadmap);
            ImageResult result = (ImageResult)req.await();
            return result.imageData;
        }
        catch (ApiException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle((Exception)((Object)ex), api);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ToolGoogleLocations.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGoogle(ex);
        }
    }

    private static GeoApiContext createContext(String api, ProxyNet proxy) {
        if (proxy == null) {
            return new GeoApiContext.Builder().apiKey(api).build();
        }
        GeoApiContext.Builder builder = new GeoApiContext.Builder().apiKey(api);
        builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getIp(), proxy.getPorta())));
        if (proxy.isPossuiAutenticacao()) {
            builder.proxyAuthentication(proxy.getUsuario(), proxy.getSenha());
        }
        return builder.build();
    }

    public static double distanceBetween2PointsMeters(Double latitude, Double longitude, Double latitude2, Double longitude2) {
        return ToolGoogleLocations.distance(latitude, longitude, latitude2, longitude2, 'K') * 1000.0;
    }

    public static double distanceBetween2PointsKM(Double latitude, Double longitude, Double latitude2, Double longitude2) {
        return ToolGoogleLocations.distance(latitude, longitude, latitude2, longitude2, 'K') * 1000.0;
    }

    private static double distance(double lat1, double lon1, double lat2, double lon2, char unit) {
        double theta = lon1 - lon2;
        double dist = Math.sin(ToolGoogleLocations.deg2rad(lat1)) * Math.sin(ToolGoogleLocations.deg2rad(lat2)) + Math.cos(ToolGoogleLocations.deg2rad(lat1)) * Math.cos(ToolGoogleLocations.deg2rad(lat2)) * Math.cos(ToolGoogleLocations.deg2rad(theta));
        dist = Math.acos(dist);
        dist = ToolGoogleLocations.rad2deg(dist);
        dist = dist * 60.0 * 1.1515;
        if (unit == 'K') {
            dist *= 1.609344;
        } else if (unit == 'N') {
            dist *= 0.8684;
        }
        return dist;
    }

    private static double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    private static double rad2deg(double rad) {
        return rad * 180.0 / Math.PI;
    }
}

