/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.hibernate;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.Id;
import javax.persistence.Version;
import org.hibernate.Hibernate;

public class ToolHibernate {
    public static Serializable getIdFromEntity(Object entity) throws ExceptionReflection {
        if (entity == null) {
            return null;
        }
        Class entityClass = Hibernate.getClass((Object)entity);
        List<Method> found = ToolReflections.getGetMethodsWithAnnotation(entityClass, Id.class);
        if (found == null || found.isEmpty()) {
            return null;
        }
        Method mh = found.get(0);
        try {
            return (Serializable)mh.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionReflection(e);
        }
        catch (IllegalArgumentException e) {
            throw new ExceptionReflection(e);
        }
        catch (InvocationTargetException e) {
            throw new ExceptionReflection(e);
        }
    }

    public static String getVersionEntity(Object entity) throws ExceptionReflection {
        if (entity == null) {
            return null;
        }
        Class entityClass = Hibernate.getClass((Object)entity);
        List<Method> found = ToolReflections.getGetMethodsWithAnnotation(entityClass, Version.class);
        if (found == null || found.isEmpty()) {
            return null;
        }
        Method mh = found.get(0);
        try {
            Serializable obj = (Serializable)mh.invoke(entity, new Object[0]);
            if (obj != null) {
                if (obj instanceof Timestamp) {
                    obj = Long.valueOf(((Timestamp)obj).getTime());
                }
                if (obj instanceof Date) {
                    obj = Long.valueOf(((Date)obj).getTime());
                }
                return String.valueOf(obj);
            }
            return String.valueOf(0L);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionReflection(e);
        }
        catch (IllegalArgumentException e) {
            throw new ExceptionReflection(e);
        }
        catch (InvocationTargetException e) {
            throw new ExceptionReflection(e);
        }
    }

    public static void setVersion(Object entity, Long versionEntity) throws ExceptionReflection {
        if (entity == null) {
            return;
        }
        Class entityClass = Hibernate.getClass((Object)entity);
        Method[] mhs = entityClass.getMethods();
        Method found = null;
        for (Method tmp : mhs) {
            if (tmp.getAnnotation(Version.class) == null) continue;
            found = tmp;
            break;
        }
        if (found != null) {
            String name = found.getName();
            Class<?> version = found.getReturnType();
            name = name.replaceFirst("get", "set");
            Date toSet = null;
            try {
                found = entityClass.getMethod(name, found.getReturnType());
                toSet = version.equals(Timestamp.class) ? new Timestamp(versionEntity) : (version.equals(Date.class) ? new Date(versionEntity) : version.getConstructor(versionEntity.getClass()).newInstance(versionEntity));
                found.invoke(entity, toSet);
            }
            catch (IllegalAccessException e) {
                throw new ExceptionReflection(e);
            }
            catch (IllegalArgumentException e) {
                throw new ExceptionReflection(e);
            }
            catch (InvocationTargetException e) {
                throw new ExceptionReflection(e);
            }
            catch (NoSuchMethodException e) {
                throw new ExceptionReflection(e);
            }
            catch (InstantiationException e) {
                throw new ExceptionReflection(e);
            }
        }
    }
}

