/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.image;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.imgscalr.Scalr;

public class ToolImage {
    public static final Dimension SIZE_MEDIUM_THUMB_NAIL = new Dimension(255, 255);
    public static final Dimension SIZE_STANDARD = new Dimension(640, 480);
    public static final Dimension SIZE_WVGA = new Dimension(720, 480);
    public static final Dimension SIZE_HD = new Dimension(1280, 720);
    public static final Dimension SIZE_FULL_HD = new Dimension(1920, 1080);
    public static final Dimension SIZE_4K = new Dimension(3840, 2160);

    public static File resizeImageKeepAspectRatioIfGreater(File imageFile, Dimension newMaxSize) throws ExceptionIO {
        Dimension d = ToolImage.getImageSize(imageFile);
        if (d.getHeight() > newMaxSize.getHeight() || d.getWidth() > newMaxSize.getWidth()) {
            try {
                return ToolImage.resizeImageKeepAspectRatio(new FileInputStream(imageFile), newMaxSize, imageFile.getName());
            }
            catch (FileNotFoundException ex) {
                throw new ExceptionIO((IOException)ex);
            }
        }
        return imageFile;
    }

    public static File resizeImageKeepAspectRatio(InputStream imageFile, Dimension newMaxSize, String fileName) throws ExceptionIO {
        try {
            BufferedImage resizeMe = ImageIO.read(imageFile);
            if (resizeMe != null) {
                BufferedImage resizedImg = Scalr.resize((BufferedImage)resizeMe, (Scalr.Method)Scalr.Method.QUALITY, (int)newMaxSize.width, (int)newMaxSize.height, (BufferedImageOp[])new BufferedImageOp[0]);
                File outputfile = TMethods.isStrWithData(fileName) ? ToolFile.createTempFile(ToolFile.getFileNameWithoutExt(fileName), ToolFile.getExtFileWithDot(fileName)) : ToolFile.createTempFile("image_conversor_temp", "");
                ImageIO.write((RenderedImage)resizedImg, "png", outputfile);
                return outputfile;
            }
            return null;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static File resizeImageKeepAspectRatio(File imageFile, Dimension newMaxSize) throws ExceptionIO {
        try {
            return ToolImage.resizeImageKeepAspectRatio(new FileInputStream(imageFile), newMaxSize, imageFile.getName());
        }
        catch (FileNotFoundException ex) {
            throw new ExceptionIO((IOException)ex);
        }
    }

    public static File resizeImageKeepAspectRatio(byte[] imageFile, Dimension newMaxSize) throws ExceptionIO {
        return ToolImage.resizeImageKeepAspectRatio(new ByteArrayInputStream(imageFile), newMaxSize, null);
    }

    public static ImageFormat getImageFormat(byte[] dataImage) throws ExceptionIO {
        if (dataImage == null) {
            return ImageFormat.UNKOWN;
        }
        return ToolImage.getImageFormat(new ByteArrayInputStream(dataImage));
    }

    public static byte[] convertImage(byte[] dataImage, ImageFormat imageFormat) throws ExceptionIO {
        return ToolImage.convertImage(new ByteArrayInputStream(dataImage), imageFormat);
    }

    public static byte[] convertImage(InputStream dataImage, ImageFormat imageFormat) throws ExceptionIO {
        try {
            if (dataImage == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            BufferedImage bufferedImage = ImageIO.read(dataImage);
            if (bufferedImage == null) {
                return null;
            }
            ImageIO.write((RenderedImage)bufferedImage, imageFormat.getType(), byteArrayOut);
            byte[] resultingBytes = byteArrayOut.toByteArray();
            return resultingBytes;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static ImageFormat getImageFormat(InputStream dataImage) throws ExceptionIO {
        try {
            if (dataImage == null) {
                return ImageFormat.UNKOWN;
            }
            ImageInputStream iis = ImageIO.createImageInputStream(dataImage);
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(iis);
            if (!imageReaders.hasNext()) {
                return ImageFormat.UNKOWN;
            }
            ImageReader reader = imageReaders.next();
            String formatName = reader.getFormatName();
            if (formatName == null) {
                return ImageFormat.UNKOWN;
            }
            if ((formatName = formatName.toLowerCase()).contains("jpg") || formatName.contains("jpeg")) {
                return ImageFormat.JPEG;
            }
            if (formatName.contains("png")) {
                return ImageFormat.PNG;
            }
            return ImageFormat.UNKOWN;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static Dimension getImageSize(File temp) throws ExceptionIO {
        try {
            return ToolImage.getImageSize(new FileInputStream(temp));
        }
        catch (FileNotFoundException ex) {
            throw new ExceptionIO((IOException)ex);
        }
    }

    public static Dimension getImageSize(InputStream temp) throws ExceptionIO {
        try {
            BufferedImage bufferedImage = ImageIO.read(temp);
            return new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static enum ImageFormat {
        PNG("png"),
        JPEG("jpeg"),
        UNKOWN("unknown");

        private final String type;

        private ImageFormat(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

