/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.java;

import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ToolJava {
    public static byte[] compileCode(String javaPathHome, String classPackageName, String code) throws ExceptionInvalidState {
        System.setProperty("java.home", javaPathHome);
        return ToolJava.compileCode(classPackageName, code);
    }

    public static byte[] compileCode(String classPackageName, String code) throws ExceptionInvalidState {
        try {
            File localDir = new File(System.getProperty("user.dir") + File.separator + "tempfiles-compiler");
            localDir.mkdirs();
            File source = new File(localDir.getAbsolutePath() + File.separator + classPackageName + ".java");
            File dest = new File(localDir.getAbsolutePath() + File.separator + classPackageName + ".class");
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new ExceptionInvalidState("E.TOL.000002", new Object[0]);
            }
            Files.write(source.toPath(), code.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int res = compiler.run(null, null, bout, "--module-path", System.getProperty("java.home") + "\\jmods", source.getPath());
            if (res != 0) {
                System.out.println("Erro ao compilar a classe " + classPackageName);
                System.out.println(bout.toString());
                throw new ExceptionInvalidState("E.TOL.000001", new Object[]{classPackageName, bout.toString()});
            }
            return FileUtils.readFileToByteArray((File)dest);
        }
        catch (ExceptionInvalidState ex) {
            throw ex;
        }
        catch (Exception ex) {
            Logger.getLogger(ToolJava.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionInvalidState("E.TOL.000001", new Object[]{ex.getMessage()});
        }
    }

    public static Class loadClassHex(String classPack, String classByteCode) throws ExceptionIO, ExceptionReflection, ExceptionDecodeHexString {
        byte[] data = ToolHexString.decodeToByte(classByteCode);
        return ToolJava.loadClass(classPack, data);
    }

    public static Class loadClassBase64(String classPack, String classByteCode) throws ExceptionIO, ExceptionReflection, ExceptionDecodeHexString64 {
        byte[] data = ToolBase64.decodeBase64(classByteCode);
        return ToolJava.loadClass(classPack, data);
    }

    public static Class loadClass(String classPack, byte[] classByteCode) throws ExceptionIO, ExceptionReflection {
        try {
            File outDir = new File(String.valueOf(ToolFile.getFileTMPDir()) + File.separator + "compiled-class-bi");
            outDir.mkdirs();
            File compiled = new File(outDir.getAbsolutePath() + File.separator + classPack + ".class");
            IOUtils.write((byte[])classByteCode, (OutputStream)new FileOutputStream(compiled));
            URL classUrl = outDir.toURL();
            URL[] classUrls = new URL[]{classUrl};
            URLClassLoader classLoader = new URLClassLoader(classUrls, ToolJava.class.getClassLoader());
            Class<?> c = classLoader.loadClass(classPack);
            return c;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionReflection(ex);
        }
    }
}

