/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.touchcomp.basementorexceptions.exceptions.impl.json.ExceptionJson;
import java.lang.reflect.Type;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ToolJsonSchema {
    public static String generateSchema(Class dto) throws ExceptionJson {
        ObjectMapper objectMapper = new ObjectMapper();
        JacksonModule module = new JacksonModule();
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(objectMapper, OptionPreset.PLAIN_JSON).with((Module)module);
        SchemaGeneratorConfig config = configBuilder.build();
        SchemaGenerator generator = new SchemaGenerator(config);
        JsonNode jsonSchema = generator.generateSchema((Type)dto, new Type[0]);
        return jsonSchema.toString();
    }

    public static boolean validateJson(JSONTokener schemaTxt, String jsonTxt) {
        JSONObject jsonSchema = new JSONObject(schemaTxt);
        JSONObject jsonSubject = new JSONObject(new JSONTokener(jsonTxt));
        Schema schema = SchemaLoader.load((JSONObject)jsonSchema);
        schema.validate((Object)jsonSubject);
        return true;
    }

    public static boolean validateJson(String schemaTxt, String jsonTxt) {
        return ToolJsonSchema.validateJson(new JSONTokener(schemaTxt), jsonTxt);
    }
}

