/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.pdf;

import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.signatures.BouncyCastleDigest;
import com.itextpdf.signatures.IExternalDigest;
import com.itextpdf.signatures.IExternalSignature;
import com.itextpdf.signatures.PdfSignatureAppearance;
import com.itextpdf.signatures.PdfSigner;
import com.itextpdf.signatures.PrivateKeySignature;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.pdf.model.PDFSignParams;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class AuxPDFSign {
    public void digitalSignature(OutputStream outputFile, Certificate[] certificateChain, PrivateKey privateKey, String bouncyCastleProvider, PDFSignParams params) throws GeneralSecurityException, IOException, ExceptionIO {
        PdfReader pdfReader = new PdfReader(params.getArquivo());
        PdfSigner pdfSigner = new PdfSigner(pdfReader, outputFile, new StampingProperties());
        PdfSignatureAppearance appearance = pdfSigner.getSignatureAppearance().setReuseAppearance(false);
        if (TMethods.isStrWithData(params.getProperties().getReason())) {
            appearance.setReason(params.getProperties().getReason());
        }
        if (TMethods.isStrWithData(params.getProperties().getReasonCaption())) {
            appearance.setReasonCaption(params.getProperties().getReasonCaption());
        }
        if (TMethods.isStrWithData(params.getProperties().getLocation())) {
            appearance.setLocation(params.getProperties().getLocation());
        }
        if (TMethods.isStrWithData(params.getProperties().getLocationCaption())) {
            appearance.setLocationCaption(params.getProperties().getLocationCaption());
        }
        if (TMethods.isStrWithData(params.getProperties().getContact())) {
            appearance.setContact(params.getProperties().getContact());
        }
        if (TMethods.isStrWithData(params.getProperties().getSignText())) {
            appearance.setLayer2Text(params.getProperties().getSignText());
        }
        if (TMethods.isWithData(Float.valueOf(params.getFontSize()))) {
            appearance.setLayer2FontSize(params.getFontSize());
        }
        if (params.getPosition() != null) {
            Rectangle rect = new Rectangle(params.getPosition().getX(), params.getPosition().getY(), params.getPosition().getWidth(), params.getPosition().getHeight());
            appearance.setPageRect(rect);
        }
        appearance.setPageNumber(params.getPageNumber());
        pdfSigner.setFieldName(params.getSignName());
        if (params.getAssinaturaImg() != null) {
            byte[] data = ToolFile.getBytesFromFile(params.getAssinaturaImg());
            appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC_AND_DESCRIPTION);
            appearance.setSignatureGraphic(ImageDataFactory.create((byte[])data));
        }
        PrivateKeySignature iExternalSignature = new PrivateKeySignature(privateKey, params.getSecurity().getSignType(), bouncyCastleProvider);
        BouncyCastleDigest iExternalDigest = new BouncyCastleDigest();
        pdfSigner.signDetached((IExternalDigest)iExternalDigest, (IExternalSignature)iExternalSignature, certificateChain, null, null, null, 0, params.getSecurity().getCryptoType());
    }
}

