/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.pdf;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.pdf.AuxPDFSign;
import com.touchcomp.basementortools.tools.pdf.model.PDFSignParams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class ToolPDF {
    public static File assinarPDF(PDFSignParams params) throws Exception {
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bouncyCastleProvider);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(params.getSecurity().getCertificate(), params.getSecurity().getPassword().toCharArray());
        String alias = keyStore.aliases().nextElement();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, params.getSecurity().getPassword().toCharArray());
        Certificate[] certificateChain = keyStore.getCertificateChain(alias);
        File temp = ToolFile.createTempFile("assinado", ".pdf");
        new AuxPDFSign().digitalSignature(new FileOutputStream(temp), certificateChain, privateKey, bouncyCastleProvider.getName(), params);
        return temp;
    }

    public static void convertHTMLToPDF(File inputHtml, File outputPDF) throws ExceptionIO {
        try {
            ITextRenderer renderer = new ITextRenderer();
            SharedContext sharedContext = renderer.getSharedContext();
            sharedContext.setPrint(true);
            sharedContext.setInteractive(false);
            renderer.setDocument(inputHtml);
            renderer.layout();
            renderer.createPDF((OutputStream)new FileOutputStream(outputPDF));
        }
        catch (IOException ex) {
            TLogger.get(ToolPDF.class).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }
}

