/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.properties;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.properties.model.VOPropertiesFile;
import com.touchcomp.basementortools.tools.properties.model.VOProperty;
import com.touchcomp.basementortools.tools.properties.model.VOSection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.ini4j.Profile;
import org.ini4j.Wini;

public class TProperties {
    public static final String DEFAULT_PROPERTIES_SECTION = "default.section";
    public static final String NO_SECTION_NAME = "?";
    private final File propsFile;
    private final Wini ini;

    public TProperties(File propsFile) throws ExceptionIO {
        this.propsFile = propsFile;
        try {
            this.ini = !propsFile.exists() ? new Wini() : new Wini(propsFile);
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    public String getProp(String propkey) throws ExceptionIO {
        return this.getPropInternal(DEFAULT_PROPERTIES_SECTION, propkey, "");
    }

    public String getProp(String section, String propkey) throws ExceptionIO {
        return this.getPropInternal(section, propkey, "");
    }

    public String addProp(String propkey, String propValue) throws ExceptionIO {
        return this.setPropInternal(DEFAULT_PROPERTIES_SECTION, propkey, propValue);
    }

    public String addProp(String section, String propkey, String propValue) throws ExceptionIO {
        return this.setPropInternal(section, propkey, propValue);
    }

    public boolean containsKey(String propkey) throws ExceptionIO {
        return this.containsKey(NO_SECTION_NAME, propkey);
    }

    public boolean containsKey(String section, String propkey) throws ExceptionIO {
        try {
            Profile.Section sec = this.getOrCreateSection(section);
            if (sec == null) {
                sec = this.ini.add(NO_SECTION_NAME);
            }
            return sec.containsKey((Object)propkey);
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    public Set<String> getSections() {
        return this.ini.keySet();
    }

    protected Profile.Section getOrCreateSection(String section) throws IOException, ExceptionIO {
        if (!this.getPropsFile().exists()) {
            this.tryToCreateDefault(this.ini);
        }
        Profile.Section sec = null;
        if (!TMethods.isEquals((Object)section, (Object)DEFAULT_PROPERTIES_SECTION)) {
            sec = this.getSection(section);
        }
        if (sec == null) {
            sec = this.getSection(NO_SECTION_NAME);
        }
        if (sec == null && this.getSections().isEmpty()) {
            sec = this.addSection(NO_SECTION_NAME);
            this.store();
        }
        if (sec == null && !this.ini.entrySet().isEmpty()) {
            sec = (Profile.Section)((Map.Entry)this.ini.entrySet().iterator().next()).getValue();
        }
        return sec;
    }

    protected String setPropInternal(String section, String propkey, String propValue) throws ExceptionIO {
        try {
            Profile.Section sec = this.getOrCreateSection(section);
            sec.put((Object)propkey, (Object)propValue);
            return (String)sec.get((Object)propkey);
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    protected String getPropInternal(String section, String propkey, String propValue) throws ExceptionIO {
        try {
            Profile.Section sec = this.getOrCreateSection(section);
            return (String)sec.get((Object)propkey);
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    public void setProperty(String key, String endApi) throws ExceptionIO {
        this.addProp(key, endApi);
    }

    public void setProperty(String section, String key, String endApi) throws ExceptionIO {
        this.addProp(section, key, endApi);
    }

    private void tryToCreateDefault(Wini ini) throws IOException {
        ini.store(this.getPropsFile());
    }

    public VOPropertiesFile getPropertiesFileData() throws ExceptionIO {
        Set data = this.ini.entrySet();
        VOPropertiesFile pf = new VOPropertiesFile(this.getPropsFile().getName());
        for (Map.Entry entry : data) {
            VOSection s = new VOSection((String)entry.getKey());
            if (TMethods.isEquals((Object)s.getName(), (Object)NO_SECTION_NAME)) {
                s.setDescription(DEFAULT_PROPERTIES_SECTION);
            }
            pf.getSections().add(s);
            for (Map.Entry prop : ((Profile.Section)entry.getValue()).entrySet()) {
                VOProperty vp = new VOProperty(s, (String)prop.getKey(), (String)prop.getValue());
                s.getProperties().add(vp);
            }
        }
        return pf;
    }

    public void storePropertiesFileData(VOPropertiesFile f) throws ExceptionIO {
        this.storePropertiesFileData(f, "");
    }

    public void storePropertiesFileData(VOPropertiesFile f, String comments) throws ExceptionIO {
        if (TMethods.isStrWithData(comments)) {
            this.ini.setComment(comments);
        }
        for (VOSection section : f.getSections()) {
            Profile.Section n = (Profile.Section)this.ini.get((Object)section.getName());
            if (n == null) {
                n = this.ini.add(section.getName());
            }
            for (VOProperty property : section.getProperties()) {
                n.add((Object)property.getName(), (Object)property.getValue());
            }
        }
        this.store();
    }

    public File getPropsFile() {
        return this.propsFile;
    }

    public void store() throws ExceptionIO {
        try {
            FileOutputStream fout = new FileOutputStream(this.getPropsFile());
            this.ini.store((OutputStream)fout);
            fout.flush();
            fout.close();
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    public Profile.Section getDefaultSection() {
        return (Profile.Section)this.ini.get((Object)DEFAULT_PROPERTIES_SECTION);
    }

    public Profile.Section getSection(String name) {
        return (Profile.Section)this.ini.get((Object)name);
    }

    public Profile.Section addSection(String name) {
        return this.ini.add(name);
    }
}

