/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.properties.model;

import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.properties.model.VOProperty;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class VOSection {
    private String name;
    private String description;
    private String nameOld;
    private List<VOProperty> properties = new LinkedList<VOProperty>();

    public VOSection(String name) {
        this.name = name;
        this.description = name;
        this.nameOld = name;
    }

    public VOProperty getProperty(String propName) {
        Optional<VOProperty> found = this.getProperties().stream().filter(i -> TMethods.isEquals((Object)i.getName(), (Object)propName)).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    public VOProperty getOrAddProperty(String propName) {
        VOProperty v = this.getProperty(propName);
        if (v != null) {
            return v;
        }
        return this.addProperty(propName);
    }

    public VOProperty getOrAddProperty(String propName, String value) {
        VOProperty v = this.getOrAddProperty(propName);
        v.setValue(value);
        return v;
    }

    public void addProperty(VOProperty property) {
        VOProperty v = this.getProperty(property.getName());
        if (v == null) {
            this.getProperties().add(property);
            return;
        }
        v.setValue(property.getValue());
    }

    public VOProperty addProperty(String name) {
        VOProperty v = this.getProperty(name);
        if (v == null) {
            v = new VOProperty(this, name);
            this.getProperties().add(v);
        }
        return v;
    }

    public String toString() {
        return this.getDescription() + "(" + this.getName() + ")";
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getNameOld() {
        return this.nameOld;
    }

    @Generated
    public List<VOProperty> getProperties() {
        return this.properties;
    }

    @Generated
    public void setProperties(List<VOProperty> properties) {
        this.properties = properties;
    }
}

