/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.reflections;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

public class AuxHibernate {
    public String getFieldDatabase(Class classe, String fullPathAtributo) throws ExceptionReflection {
        StringTokenizer sk = new StringTokenizer(fullPathAtributo, ".");
        String db = null;
        while (sk.hasMoreElements()) {
            db = null;
            String tk = sk.nextToken();
            Field f = ToolReflections.getField(classe, tk);
            Method m = ToolReflections.getMethodGet(f, classe);
            OneToOne oneToOne = null;
            OneToMany oneToMany = null;
            JoinTable joinTable = null;
            if (m != null) {
                db = this.getFieldColumnDb(m);
                oneToOne = m.getAnnotation(OneToOne.class);
                oneToMany = m.getAnnotation(OneToMany.class);
                joinTable = m.getAnnotation(JoinTable.class);
            }
            if (db == null) {
                db = this.getFieldColumnDb(f);
                oneToOne = f.getAnnotation(OneToOne.class);
                oneToMany = f.getAnnotation(OneToMany.class);
                joinTable = f.getAnnotation(JoinTable.class);
            }
            if (!ToolReflections.isPrimitive(f.getType())) {
                try {
                    classe = ToolReflections.getHibernateEntityClass(f);
                    String ret = this.getFieldCasosEspeciais(classe, m, f, oneToOne, oneToMany, joinTable);
                    if (ret == null) continue;
                    db = ret;
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    throw new ExceptionReflection(ex);
                }
            }
            if (!ToolReflections.isPrimitive(f.getType()) || db != null) continue;
            db = tk;
        }
        return db;
    }

    private String getFieldColumnDb(Method met) {
        Column column = met.getAnnotation(Column.class);
        if (column != null) {
            return column.name();
        }
        JoinColumn join = met.getAnnotation(JoinColumn.class);
        if (join != null) {
            return join.name();
        }
        return null;
    }

    private String getFieldColumnDb(Field met) {
        Column column = met.getAnnotation(Column.class);
        if (column != null) {
            return column.name();
        }
        JoinColumn join = met.getAnnotation(JoinColumn.class);
        if (join != null) {
            return join.name();
        }
        return null;
    }

    private String getFieldCasosEspeciais(Class base, Method m, Field f, OneToOne oneToOne, OneToMany oneToMany, JoinTable joinTable) throws ExceptionReflection, ClassNotFoundException {
        Object db = null;
        if (joinTable != null) {
            JoinColumn[] joins;
            db = joinTable.name();
            db = (String)db + "/";
            for (JoinColumn join : joins = joinTable.joinColumns()) {
                db = (String)db + join.name() + ";";
            }
            return db;
        }
        String mappebBy = null;
        if (oneToOne != null) {
            mappebBy = oneToOne.mappedBy();
        }
        if (oneToMany != null) {
            mappebBy = oneToMany.mappedBy();
        }
        if (mappebBy != null) {
            Class type = null;
            if (m != null) {
                type = ToolReflections.getHibernateEntityClass(m);
            }
            if (type == null && f != null) {
                type = ToolReflections.getHibernateEntityClass(f);
            }
            f = ToolReflections.getField(type, mappebBy);
            m = ToolReflections.getMethodGet(f, type);
            db = this.getTableName(type);
            db = (String)db + "/";
            String field = null;
            if (m != null) {
                field = this.getFieldColumnDb(m);
            }
            if (field == null) {
                field = this.getFieldColumnDb(f);
            }
            if (field != null) {
                db = (String)db + field;
            }
        }
        return db;
    }

    public String getTableName(Class type) {
        Table t = type.getAnnotation(Table.class);
        if (t != null) {
            return t.name();
        }
        return type.getSimpleName().toUpperCase();
    }
}

