/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.textdynamic;

import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.EnumExcepInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.constants.EnumConstantsTextDynamic;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.ListenerAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.ToolAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.model.DTOAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.model.DTOResultCalcExpressoes;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ToolTextDynamic {
    public static String getAuxToken(String token) {
        return EnumConstantsTextDynamic.PREFIX_TOKEN_AUX.getToken() + token;
    }

    public static boolean isAuxToken(String token) {
        if (token == null) {
            return false;
        }
        return token.startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_AUX.getToken());
    }

    public static String getAuxField(String token) {
        if (token == null) {
            return "";
        }
        return EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken() + token;
    }

    public static String getAuxSubObs(String token, Long idSubOS) {
        return EnumConstantsTextDynamic.PREFIX_TOKEN_SUB_OBS.getToken() + idSubOS + "," + EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken() + token;
    }

    public static List<StringToken> getAuxTokens(String observacao) {
        return ToolTextDynamic.getAuxTokens(observacao, new LinkedList());
    }

    public static boolean isValidToAdd(String condicaoAplicacao, final Object source) throws ExceptionInvalidData {
        try {
            DTOAvaliadorExpressoes.DTOFormula form = new DTOAvaliadorExpressoes.DTOFormula();
            form.setAtivo(EnumConstantsSimNao.SIM.getValue());
            form.setCondicao("1");
            form.setFormula(condicaoAplicacao);
            DTOAvaliadorExpressoes dto = new DTOAvaliadorExpressoes();
            dto.setDescricao(condicaoAplicacao);
            dto.getFormulas().add(form);
            DTOResultCalcExpressoes res = ToolAvaliadorExpressoes.processAndValidateValue(dto, new HashMap<String, Object>(), new ListenerAvaliadorExpressoes(){

                @Override
                public boolean isAvailable(String chave) {
                    return true;
                }

                @Override
                public Double processVar(String chave, String[] otherValues, Map<String, Object> values) {
                    if (!chave.startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken())) {
                        return 0.0;
                    }
                    chave = chave.substring(EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken().length());
                    try {
                        Object obj = ToolReflections.getFieldValueFromGetMethod(chave, source);
                        if (obj != null && obj instanceof Number) {
                            return ((Number)obj).doubleValue();
                        }
                        if (obj != null && obj instanceof String) {
                            return String.valueOf(obj).length() > 0 ? 1.0 : 0.0;
                        }
                        if (obj != null) {
                            return 1.0;
                        }
                        return 0.0;
                    }
                    catch (ExceptionReflection ex) {
                        TLogger.get(ToolTextDynamic.class).error((Throwable)ex);
                        return 0.0;
                    }
                }
            });
            return res.getResultado().equals(1.0);
        }
        catch (ExceptionAvaliadorExpressoes ex) {
            TLogger.get(ToolTextDynamic.class).error((Throwable)ex);
            throw new ExceptionInvalidData("", new Object[]{condicaoAplicacao});
        }
    }

    public static List<StringToken> getAuxTokens(String observacao, List tokens) {
        if (observacao == null) {
            return new ArrayList<StringToken>();
        }
        HashSet<StringToken> h = new HashSet<StringToken>(tokens);
        h.addAll(ToolString.getReplaceTokens(observacao));
        LinkedList<StringToken> filtered = new LinkedList<StringToken>();
        for (StringToken t : h) {
            if (!t.getChave().startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_AUX.getToken())) continue;
            filtered.add(t);
        }
        return filtered;
    }

    public static String build(Object source, String obs, HelperSubOSFinder listener) throws ExceptionReflection, ExceptionInvalidData {
        return ToolTextDynamic.build(source, obs, listener, true);
    }

    public static String build(Object source, String obs, HelperSubOSFinder listener, boolean formatFields) throws ExceptionReflection, ExceptionInvalidData {
        if (obs == null) {
            return "";
        }
        List<StringToken> all = ToolString.getReplaceTokens(obs);
        LinkedList<StringToken> tokensInfManual = new LinkedList<StringToken>();
        for (StringToken a : all) {
            if (a.getChave().startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_AUX.getToken())) {
                a.setValor(ToolTextDynamic.getValorDigitado(source, tokensInfManual, a.getChave()));
                continue;
            }
            if (a.getChave().startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken())) {
                a.setValor(ToolTextDynamic.getField(a.getChave(), source, formatFields));
                continue;
            }
            if (a.getChave().startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_SUB_OBS.getToken())) {
                a.setValor(ToolTextDynamic.getFieldSubObs(a, source, tokensInfManual, listener));
                continue;
            }
            throw new ExceptionInvalidData(EnumExcepInvalidData.DADOS_INVALIDOS, new Object[]{"Token invalido: " + a.getChave()});
        }
        return ToolString.build(obs, all);
    }

    public static String build(String obs, String condicaoAplicacao, List<StringToken> tokens, HelperSubOSFinder listener) throws ExceptionReflection, ExceptionInvalidData {
        return ToolTextDynamic.build(null, tokens, obs, condicaoAplicacao, listener);
    }

    public static String build(Object source, List<StringToken> tokens, String obs, String condicaoAplicacao, HelperSubOSFinder listener) throws ExceptionReflection, ExceptionInvalidData {
        return ToolTextDynamic.build(source, tokens, obs, condicaoAplicacao, listener, true);
    }

    public static String build(Object source, List<StringToken> tokens, String obs, String condicaoAplicacao, HelperSubOSFinder listener, boolean formatFields) throws ExceptionReflection, ExceptionInvalidData {
        if (obs == null) {
            return "";
        }
        if (tokens == null) {
            tokens = new LinkedList<StringToken>();
        }
        if (ToolMethods.isStrWithData(condicaoAplicacao) && !ToolTextDynamic.isValidToAdd(condicaoAplicacao, source)) {
            return "";
        }
        List<StringToken> all = ToolString.getReplaceTokens(obs);
        for (StringToken a : all) {
            if (a.getChave().startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_AUX.getToken())) {
                a.setValor(ToolTextDynamic.getValorDigitado(source, tokens, a.getChave()));
                continue;
            }
            if (a.getChave().startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken())) {
                a.setValor(ToolTextDynamic.getField(a.getChave(), source, formatFields));
                continue;
            }
            if (a.getChave().startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_SUB_OBS.getToken())) {
                a.setValor(ToolTextDynamic.getFieldSubObs(a, source, tokens, listener));
                continue;
            }
            throw new ExceptionInvalidData(EnumExcepInvalidData.DADOS_INVALIDOS, new Object[]{"Token invalido: " + a.getChave()});
        }
        return ToolString.build(obs, all);
    }

    private static String getField(String token, Object source, boolean formatFields) throws ExceptionReflection {
        if (token == null || source == null) {
            return "";
        }
        String field = token;
        field = field.substring(EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken().length());
        Object value = ToolReflections.getFieldValueFromGetMethod(field, source);
        String str = String.valueOf(value);
        if (formatFields) {
            str = ToolFormatter.format(value);
        }
        return str;
    }

    private static String getFieldSubObs(StringToken a, Object source, List<StringToken> tokens, HelperSubOSFinder listener) throws ExceptionReflection, ExceptionInvalidData {
        int end = a.getChave().indexOf(",");
        String obs = a.getChave().substring(0, end);
        String field = a.getChave().substring(end + 1);
        field = field.substring(EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken().length());
        obs = obs.substring(EnumConstantsTextDynamic.PREFIX_TOKEN_SUB_OBS.getToken().length());
        if (source == null) {
            return "";
        }
        String sub = listener.getSubOSText(Long.valueOf(obs));
        String condicacaoAplicacao = listener.getSubOSTextCond(Long.valueOf(obs));
        if (obs == null) {
            throw new ExceptionInvalidData(EnumExcepInvalidData.DADOS_INVALIDOS, new Object[]{"Obs nao encontada para id " + obs + " para token " + a.getChave()});
        }
        Object value = ToolReflections.getFieldValueFromGetMethod(field, source);
        if (value != null && Collection.class.isInstance(value)) {
            Collection temp = (Collection)value;
            Object aux = "";
            for (Object col : temp) {
                aux = (String)aux + ToolTextDynamic.build(col, tokens, sub, condicacaoAplicacao, listener);
            }
            return aux;
        }
        return ToolTextDynamic.build(value, tokens, sub, condicacaoAplicacao, listener);
    }

    private static String getValorDigitado(Object source, List<StringToken> tokens, String chave) {
        Map data;
        for (StringToken token : tokens) {
            if (token.getChave().equalsIgnoreCase(chave)) {
                return token.getValor();
            }
            if (!chave.endsWith(token.getChave())) continue;
            return token.getValor();
        }
        if (source instanceof Map && (data = (Map)source).containsKey(chave)) {
            return String.valueOf(data.get(chave));
        }
        return "";
    }

    public static interface HelperSubOSFinder {
        public String getSubOSText(Long var1);

        public String getSubOSTextCond(Long var1);
    }
}

