/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.textfile.genericreader;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.textfile.genericreader.model.TextLineConfig;
import com.touchcomp.basementortools.tools.textfile.genericreader.model.TextLineGenericReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

public final class ToolTextGenericFileReader {
    private Character decSeparator = Character.valueOf(',');
    private String dateMask = "dd/MM/yyyy";
    private String dateTimeMask = "dd/MM/yyyy HH:mm:ss";
    private List<TextLineGenericReader> lines = new LinkedList<TextLineGenericReader>();
    private int indexLine = -1;
    private TextLineConfig readerConfig;

    public ToolTextGenericFileReader(TextLineConfig readerConfig) {
        this.readerConfig = readerConfig;
    }

    public ToolTextGenericFileReader(InputStream input, TextLineConfig readerConfig) throws ExceptionIO {
        this(readerConfig);
        this.read(input);
    }

    public ToolTextGenericFileReader(File input, TextLineConfig readerConfig) throws ExceptionIO {
        this(readerConfig);
        this.read(input);
    }

    public ToolTextGenericFileReader(String contentFile, TextLineConfig readerConfig) throws ExceptionIO {
        this(readerConfig);
        this.read(contentFile);
    }

    public ToolTextGenericFileReader read(InputStream input) throws ExceptionIO {
        try {
            this.lines.clear();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                String line = reader.readLine();
                int counter = 0;
                while (line != null) {
                    if (this.getIndexLine() <= 0 || counter <= this.getIndexLine()) {
                        this.newLine(line);
                    }
                    line = reader.readLine();
                }
            }
            return this;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public ToolTextGenericFileReader read(File input) throws ExceptionIO {
        try {
            return this.read(new FileInputStream(input));
        }
        catch (FileNotFoundException ex) {
            throw new ExceptionIO((IOException)ex, new Object[]{ex.getMessage()});
        }
    }

    public ToolTextGenericFileReader read(String contentFile) throws ExceptionIO {
        return this.read(new ByteArrayInputStream(contentFile.getBytes()));
    }

    public Character getDecSeparator() {
        return this.decSeparator;
    }

    public ToolTextGenericFileReader setDecSeparator(Character decSeparator) {
        this.decSeparator = decSeparator;
        return this;
    }

    public String getDateMask() {
        return this.dateMask;
    }

    public ToolTextGenericFileReader setDateMask(String dateMask) {
        this.dateMask = dateMask;
        return this;
    }

    public String getDateTimeMask() {
        return this.dateTimeMask;
    }

    public ToolTextGenericFileReader setDateTimeMask(String dateTimeMask) {
        this.dateTimeMask = dateTimeMask;
        return this;
    }

    public List<TextLineGenericReader> getLines() {
        return this.lines;
    }

    private TextLineGenericReader newLine(String line) {
        TextLineConfig.Line lineConfig = this.getLineConfig(line);
        if (lineConfig == null) {
            return null;
        }
        TextLineGenericReader aux = new TextLineGenericReader(this, lineConfig);
        aux.readRegs(line);
        this.lines.add(aux);
        return aux;
    }

    public int getIndexLine() {
        return this.indexLine;
    }

    public void setIndexLine(int indexLine) {
        this.indexLine = indexLine;
    }

    protected TextLineConfig.Line getLineConfig(String fullLineText) {
        for (TextLineConfig.Line line : this.readerConfig.getLines()) {
            if (!this.isThat(line, fullLineText)) continue;
            return line;
        }
        return null;
    }

    private boolean isThat(TextLineConfig.Line line, String fullLineText) {
        for (TextLineConfig.RegKey keyReg : line.getKeyRegs()) {
            if (keyReg.getEndIndex() > fullLineText.length()) {
                return false;
            }
            if (fullLineText.substring(keyReg.getStartIndex(), keyReg.getEndIndex()).equals(keyReg.getExpectedkeyValue())) continue;
            return false;
        }
        return true;
    }
}

