/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.textfile.reader.model;

import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.textfile.reader.model.TextLineReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextLineRegReader {
    private final String data;
    private final TextLineReader lineReader;

    public TextLineRegReader(TextLineReader lineReader, String data) {
        this.lineReader = lineReader;
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public TextLineReader getLineReader() {
        return this.lineReader;
    }

    public int asInt() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return Integer.parseInt(tmp);
    }

    public short asShort() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return Short.parseShort(tmp);
    }

    public long asLong() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return Long.parseLong(tmp);
    }

    public double asDouble() throws ExceptionParseObject {
        String tmp = this.data;
        String string = tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        if (this.lineReader.getReader().getDecSeparator() != null) {
            DecimalFormat d = new DecimalFormat();
            DecimalFormatSymbols symb = DecimalFormatSymbols.getInstance();
            symb.setDecimalSeparator(this.lineReader.getReader().getDecSeparator().charValue());
            d.setDecimalFormatSymbols(symb);
            try {
                return d.parse(tmp).floatValue();
            }
            catch (ParseException ex) {
                Logger.getLogger(TextLineReader.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionParseObject(ex, new Object[]{tmp});
            }
        }
        return Double.parseDouble(tmp);
    }

    public double asDouble(String pattern) throws ExceptionParseObject {
        String tmp = this.data;
        String string = tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        if (this.lineReader.getReader().getDecSeparator() != null) {
            DecimalFormat d = new DecimalFormat(pattern);
            try {
                return d.parse(tmp).floatValue();
            }
            catch (ParseException ex) {
                Logger.getLogger(TextLineReader.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionParseObject(ex, new Object[]{tmp});
            }
        }
        return Double.parseDouble(tmp);
    }

    public float asFloat() throws ExceptionParseObject {
        String tmp = this.data;
        String string = tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        if (this.lineReader.getReader().getDecSeparator() != null) {
            DecimalFormat d = new DecimalFormat();
            DecimalFormatSymbols symb = DecimalFormatSymbols.getInstance();
            symb.setDecimalSeparator(this.lineReader.getReader().getDecSeparator().charValue());
            d.setDecimalFormatSymbols(symb);
            try {
                return d.parse(tmp).floatValue();
            }
            catch (ParseException ex) {
                Logger.getLogger(TextLineReader.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionParseObject(ex, new Object[]{tmp});
            }
        }
        return Float.parseFloat(tmp);
    }

    public float asFloat(String pattern) throws ExceptionParseObject {
        String tmp = this.data;
        String string = tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        if (this.lineReader.getReader().getDecSeparator() != null) {
            DecimalFormat d = new DecimalFormat(pattern);
            try {
                return d.parse(tmp).floatValue();
            }
            catch (ParseException ex) {
                Logger.getLogger(TextLineReader.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionParseObject(ex, new Object[]{tmp});
            }
        }
        return Float.parseFloat(tmp);
    }

    public Date asDate() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return ToolDate.strToDate(tmp, this.lineReader.getReader().getDateMask());
    }

    public Date asDateTime() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return ToolDate.strToDate(tmp, this.lineReader.getReader().getDateTimeMask());
    }

    public Date asDate(String mask) {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return ToolDate.strToDate(tmp, mask);
    }

    public Date asDateTime(String mask) {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "0" : tmp;
        return ToolDate.strToDate(tmp, mask);
    }

    public String asString() {
        String tmp = this.data;
        tmp = tmp == null || tmp.isEmpty() ? "" : tmp;
        return tmp;
    }

    public String toString() {
        return this.data;
    }
}

