/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.xtream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.LinkedList;

public class ToolXtreamXML {
    public static String toXML(Object obj, Pair ... pairs) {
        XStream xstream = ToolXtreamXML.defaultXtream();
        if (pairs.length == 0) {
            ToolXtreamXML.setPairs(xstream, new Pair(obj.getClass()));
        } else {
            ToolXtreamXML.setPairs(xstream, pairs);
        }
        return xstream.toXML(obj);
    }

    private static void setPairs(XStream xstream, Pair ... pairs) {
        LinkedList allow = new LinkedList();
        for (Pair pair : pairs) {
            if (pair.justClazz) {
                xstream.processAnnotations(pair.clazz);
            } else {
                xstream.alias(pair.aliases, pair.clazz);
            }
            allow.add(pair.clazz);
        }
        xstream.allowTypes(allow.toArray(new Class[0]));
    }

    public static <T> T toObject(Class<T> clazz, String xml) {
        return (T)ToolXtreamXML.toObject(xml, new Pair(clazz));
    }

    public static Object toObject(String xml, Pair ... pairs) {
        XStream xstream = ToolXtreamXML.defaultXtream();
        ToolXtreamXML.setPairs(xstream, pairs);
        return xstream.fromXML(xml);
    }

    private static XStream defaultXtream() {
        XStream xTream = new XStream((HierarchicalStreamDriver)new DomDriver());
        return xTream;
    }

    public static class Pair {
        private String aliases;
        private Class<?> clazz;
        private boolean justClazz;

        public Pair(String aliases, Class<?> clazz) {
            this.aliases = aliases;
            this.clazz = clazz;
            this.setJustClazz(false);
        }

        public Pair(Class<?> clazz) {
            this.clazz = clazz;
            this.setJustClazz(true);
        }

        public String getAliases() {
            return this.aliases;
        }

        public void setAliases(String aliases) {
            this.aliases = aliases;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public boolean isJustClazz() {
            return this.justClazz;
        }

        public void setJustClazz(boolean justClazz) {
            this.justClazz = justClazz;
        }
    }
}

