/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.crud.impl;

import com.touchcomp.basementor.constants.enums.crud.EnumConstCRUD;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.crud.ValidGenericCrudImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidCrudPedidoImpl
extends ValidGenericCrudImpl<Pedido> {
    @Override
    protected void isValid(Pedido vo, EnumConstCRUD operacao) {
        if (TMethods.isWithData((Collection)vo.getExpedicao())) {
            this.addError(this.code("V.ERP.1180.052", vo.getIdentificador()), vo);
            if (((Expedicao)vo.getExpedicao().get(0)).getNotaFiscalPropria() != null) {
                this.addError(this.code("V.ERP.1180.053", vo.getIdentificador()), vo);
            }
        }
        if (vo.getUnificacaoPedido() != null) {
            this.addError(this.code("V.ERP.1180.054", vo.getIdentificador()), vo);
        }
        if (operacao.isUpdate() && vo.getSituacaoPedido() != null && TMethods.isAffirmative((Number)vo.getSituacaoPedido().getCancelarTitulos())) {
            this.addError(this.code("V.ERP.1180.055", vo.getIdentificador()), vo);
        }
        if (operacao.isDelete() && vo.getSituacaoPedido() != null && TMethods.isAffirmative((Number)vo.getSituacaoPedido().getBloqueioExclusaoPedidoPorSituacao())) {
            this.addError(this.code("V.ERP.1180.056", vo.getIdentificador()), vo);
        }
        if (vo.getSituacaoPedido() != null && this.isAffirmative(vo.getSituacaoPedido().getBloqueioPedidoPorSituacao())) {
            this.addError(this.code("V.ERP.1180.056", vo.getIdentificador()), vo);
        }
        if (vo.getLiberacaoMTC() != null) {
            this.addError(this.code("V.ERP.1180.057", vo.getIdentificador()), vo);
        }
        if (vo.getGeracaoTituloPedido() != null) {
            this.addError(this.code("V.ERP.1180.057", vo.getIdentificador()), vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "Validacao edicao de pedidos";
    }
}

