/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities;

import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementorvalidator.dto.ValidGenericDTOImpl;
import com.touchcomp.basementorvalidator.entities.ValidGeneric;
import com.touchcomp.basementorvalidator.entities.ValidImpl;
import com.touchcomp.basementorvalidator.entities.model.ValidContainer;
import com.touchcomp.basementorvalidator.entities.model.ValidContainerItem;
import com.touchcomp.touchvomodel.vo.DTOObjectInterface;
import java.beans.IntrospectionException;
import java.lang.reflect.Type;
import java.util.List;
import javax.persistence.Inheritance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Inheritance
public abstract class ValidGenericEntitiesImpl<E extends InterfaceVO>
extends ValidImpl
implements ValidGeneric<E> {
    private int currentPos = 1;
    @Autowired
    InterfaceStaticObjects interfaceStatObjects;
    private Class<E> entityClass;

    @Override
    public void createNewContainers() {
        this.setContainer(new ValidContainer());
        this.setContainerWarns(new ValidContainer());
    }

    @Override
    public void isValidData(List<E> entity) {
        if (entity == null) {
            return;
        }
        entity.forEach(item -> {
            this.isValidData(item);
            ++this.currentPos;
        });
    }

    @Override
    public final void isValidData(E entity) {
        if (entity == null) {
            this.newMessageItem(this.code("V.ERP.0000.007"), null);
        } else {
            this.isValid(entity);
        }
    }

    protected abstract void isValid(E var1);

    public boolean valid(ValidGenericEntitiesImpl valid, List<? extends InterfaceVO> aux) {
        valid.clearContainerErrors();
        valid.isValidData((E)aux);
        if (valid.getContainer() != null) {
            this.getContainer().addItens(valid.getContainer().getItens());
        }
        return valid.hasErrors();
    }

    public void valid(ValidGenericDTOImpl valid, List<? extends DTOObjectInterface> aux) {
        valid.clearContainerErrors();
        valid.isValidData(aux);
        if (valid.getContainer() != null) {
            this.getContainer().addItens(valid.getContainer().getItens());
        }
    }

    public void validWarn(ValidGenericEntitiesImpl valid, List<? extends InterfaceVO> aux) {
        valid.clearContainerWarn();
        valid.isValidData((E)aux);
        if (valid.getContainerWarns() != null) {
            this.getContainerWarns().addItens(valid.getContainerWarns().getItens());
        }
    }

    public void validWarn(ValidGenericDTOImpl valid, List<? extends DTOObjectInterface> aux) {
        valid.clearContainerWarn();
        valid.isValidData(aux);
        if (valid.getContainerWarns() != null) {
            this.getContainerWarns().addItens(valid.getContainerWarns().getItens());
        }
    }

    public boolean valid(ValidGenericEntitiesImpl valid, InterfaceVO aux) {
        valid.clearContainerErrors();
        valid.isValidData(aux);
        if (valid.getContainer() != null) {
            this.getContainer().addItens(valid.getContainer().getItens());
            this.getContainerWarns().addItens(valid.getContainerWarns().getItens());
        }
        return !valid.hasErrors();
    }

    public void valid(ValidGenericDTOImpl valid, DTOObjectInterface aux) {
        valid.clearContainerErrors();
        valid.isValidData(aux);
        if (valid.getContainer() != null) {
            this.getContainer().addItens(valid.getContainer().getItens());
            this.getContainerWarns().addItens(valid.getContainerWarns().getItens());
        }
    }

    public void validWarn(ValidGenericEntitiesImpl valid, InterfaceVO aux) {
        valid.clearContainerWarn();
        valid.isValidData(aux);
        this.getContainerWarns().addItens(valid.getContainerWarns().getItens());
    }

    public void validWarn(ValidGenericDTOImpl valid, DTOObjectInterface aux) {
        valid.clearContainerWarn();
        valid.isValidData(aux);
        this.getContainerWarns().addItens(valid.getContainerWarns().getItens());
    }

    public String toString() {
        return "Erros: " + this.getContainer().asString() + " \n\nAdvertencias: " + this.getContainerWarns().asString();
    }

    public InterfaceStaticObjects getSharedObjects() {
        return this.interfaceStatObjects;
    }

    private Class<?> getClassType() {
        Type t = this.getClass().getGenericSuperclass();
        if (t instanceof Class && ValidGenericEntitiesImpl.class.isAssignableFrom((Class)t)) {
            return (Class)t;
        }
        return this.getClass();
    }

    public Class<E> getEntityClass() {
        if (this.entityClass == null) {
            this.entityClass = ToolReflections.getGenericTypeClass(this.getClassType(), (int)0);
        }
        return this.entityClass;
    }

    public List<ValidContainerItem> getValidationCodes() throws ExceptionReflection {
        try {
            Class<E> entity = this.getEntityClass();
            InterfaceVO data = (InterfaceVO)entity.newInstance();
            ToolReflections.setNullFields((Object)data);
            this.clearContainerErrors();
            this.valid(this, data);
            return this.getContainer().getItens();
        }
        catch (InstantiationException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (IllegalAccessException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (IntrospectionException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (ExceptionReflection ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
    }
}

