/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.validacao.EnumValidacaoTipo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorspringcontext.listeners.BeanListener;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.ValidCheck;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.basementorvalidator.entities.model.ValidContainer;
import com.touchcomp.basementorvalidator.entities.model.ValidContainerItem;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Collection;
import java.util.Date;

public class ValidImpl
implements BeanListener {
    private final TLogger logger = TLogger.get(this.getClass());
    private ValidContainer container = new ValidContainer();
    private ValidContainer containerWarns = new ValidContainer();
    private final ValidCheck validChek = new ValidCheck();
    private int currentPos = 1;

    public ValidImpl() {
    }

    public ValidImpl(ValidContainer container) {
        this.containerWarns = new ValidContainer();
        this.container = container;
    }

    public boolean isEquals(Object ob1, Object ob2) {
        return ToolMethods.isEquals((Object)ob1, (Object)ob2);
    }

    public boolean isEqualsNumber(Number ob1, Number ob2) {
        return ToolMethods.isEqualsNumber((Number)ob1, (Number)ob2);
    }

    public boolean isAffirmative(Number nr) {
        return ToolMethods.isAffirmative((Number)nr);
    }

    public boolean valid(ValidMessages.Code code, Object value) {
        if (value == null) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validNotData(ValidMessages.Code code, Object value) {
        if (value != null) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validAffirmative(ValidMessages.Code code, Short value) {
        if (value == null || !this.isAffirmative(value)) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validNotEquals(ValidMessages.Code code, Object value, Object expected) {
        if (value == null || !this.isEquals(value, expected)) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validNotEqualsWarn(ValidMessages.Code code, Object value, Object expected) {
        if (value == null || !this.isEquals(value, expected)) {
            this.newMessageItemWarn(code, value);
            return false;
        }
        return true;
    }

    public boolean validEquals(ValidMessages.Code code, Object value, Object expected) {
        if (value == null || this.isEquals(value, expected)) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validOnlyNumbers(ValidMessages.Code code, String value) {
        if (value == null) {
            this.newMessageItem(code, value);
            return false;
        }
        if (!ToolString.stringIsANumberInteger((String)value).booleanValue()) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validWarn(ValidMessages.Code code, Object value) {
        if (value == null) {
            this.newMessageItemWarn(code, value);
            return false;
        }
        return true;
    }

    public boolean valid(ValidMessages.Code code, String value) {
        if (value == null || value.isEmpty()) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validWarn(ValidMessages.Code code, String value) {
        if (value == null || value.isEmpty()) {
            this.newMessageItemWarn(code, value);
            return false;
        }
        return true;
    }

    public boolean validNotEmpty(ValidMessages.Code code, Collection value) {
        if (value == null || value.isEmpty()) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validNotEmpty(ValidMessages.Code code, Collection value, Object ... adicional) {
        if (value == null || value.isEmpty()) {
            this.newMessageItem(code, value, adicional);
            return false;
        }
        return true;
    }

    public boolean validWarn(ValidMessages.Code code, Collection value) {
        if (value == null || value.isEmpty()) {
            this.newMessageItemWarn(code, value);
            return false;
        }
        return true;
    }

    public void valid(Object value, String messageCode, Object ... adicional) {
        if (value == null) {
            this.newMessageItem(new ValidMessages.Code(messageCode, adicional), value);
        }
    }

    public void validNotEmpty(Collection<Object> value, String messageCode, Object ... adicional) {
        if (value == null || value.isEmpty()) {
            this.newMessageItem(new ValidMessages.Code(messageCode, adicional), value);
        }
    }

    public void valid(Number value, String messageCode, Object ... adicional) {
        if (value == null) {
            this.newMessageItem(new ValidMessages.Code(messageCode, adicional), value);
        }
    }

    public boolean validWarn(ValidMessages.Code code, Number value) {
        if (value == null) {
            this.newMessageItemWarn(code, value);
            return false;
        }
        return true;
    }

    public boolean valid(String value, String messageCode, Object ... adicional) {
        boolean ret = true;
        if (value == null) {
            this.newMessageItem(new ValidMessages.Code(messageCode, adicional), value);
            ret = false;
        }
        if (value != null && value.length() == 0) {
            this.newMessageItem(new ValidMessages.Code(messageCode, adicional), value);
            ret = false;
        }
        return ret;
    }

    public boolean validNotEquals(ValidMessages.Code code, String value, String value1, String value2) {
        if (value1.equals(value2)) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validNotEqualsWarn(ValidMessages.Code code, String value, String value1, String value2) {
        if (value1.equals(value2)) {
            this.newMessageItemWarn(code, value);
            return false;
        }
        return true;
    }

    public boolean valid0(ValidMessages.Code code, Number value) {
        this.valid(code, value);
        if (value != null && value.doubleValue() < 0.0) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validGreather0(ValidMessages.Code code, Number value) {
        this.valid(code, value);
        if (value != null && value.doubleValue() <= 0.0) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validGreather0(ValidMessages.Code code, Number value, Object ... adicional) {
        this.valid(code, value);
        if (value != null && value.doubleValue() <= 0.0) {
            this.newMessageItem(code, value, adicional);
            return false;
        }
        return true;
    }

    public boolean validMin(ValidMessages.Code code, Number value, Number min) {
        this.valid(code, value);
        if (value != null && min != null && value.doubleValue() < min.doubleValue()) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validMax(ValidMessages.Code code, Number value, Number max) {
        this.valid(code, value);
        if (value != null && max != null && value.doubleValue() > max.doubleValue()) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validMinMax(ValidMessages.Code code, Number value, Number min, Number max) {
        this.valid(code, value);
        this.validMin(code, value, min);
        this.validMax(code, value, max);
        return true;
    }

    public boolean validMinWarn(ValidMessages.Code code, Number value, Number min) {
        this.validWarn(code, value);
        if (value != null && min != null && value.doubleValue() < min.doubleValue()) {
            this.newMessageItemWarn(code, (Object)value, "V.ERP.0000.002");
            return false;
        }
        return true;
    }

    public void validMin(Number value, Number min, String messageCode, Object ... adicional) {
        if (value == null) {
            this.newMessageItem(new ValidMessages.Code(messageCode, adicional), value);
        }
        if (value != null && value.doubleValue() < min.doubleValue()) {
            this.newMessageItem(new ValidMessages.Code(messageCode, adicional), value);
        }
    }

    public void validMin(String value, int min, String messageCode, Object ... adicional) {
        if (value == null) {
            this.newMessageItem(new ValidMessages.Code(messageCode, adicional), value);
        }
        if (value != null && value.length() < min) {
            this.newMessageItem(new ValidMessages.Code(messageCode, adicional), value);
        }
    }

    public boolean validMinLenght(ValidMessages.Code code, String value, int minLength) {
        this.valid(code, value);
        if (value != null && value.length() < minLength) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validMinLenghtWarn(ValidMessages.Code code, String value, int minLength) {
        this.validWarn(code, value);
        if (value != null && value.length() < minLength) {
            this.newMessageItemWarn(code, value);
            return false;
        }
        return true;
    }

    public boolean validBefore(ValidMessages.Code code, Date date1, Date date2, Object ... adicional) {
        this.valid(code, date1);
        this.valid(code, date2);
        if (date1 != null && date2 != null && date2.before(date1)) {
            this.newMessageItem(code, date1, date2);
            return false;
        }
        return true;
    }

    public boolean validAfter(ValidMessages.Code code, Date date1, Date date2, Object ... adicional) {
        this.valid(code, date1);
        this.valid(code, date2);
        if (date1 != null && date2 != null && date1.after(date2)) {
            this.newMessageItem(code, date1, date2);
            return false;
        }
        return true;
    }

    public boolean validAfterEqual(ValidMessages.Code code, Date date1, Date date2, Object ... adicional) {
        this.valid(code, date1);
        this.valid(code, date2);
        if (date1 != null && date2 != null && !date1.after(date2) && !date1.equals(date2)) {
            this.newMessageItem(code, date1, date2);
            return false;
        }
        return true;
    }

    public boolean validEqualMonthYear(ValidMessages.Code code, Date date1, Date date2, Object ... adicional) {
        this.valid(code, date1);
        this.valid(code, date2);
        if (date1 != null && date2 != null && !ToolDate.comparePeriodFromDates((Date)date1, (Date)date2).booleanValue()) {
            this.newMessageItem(code, date1, date2);
            return false;
        }
        return true;
    }

    public boolean validBetween(ValidMessages.Code code, Date date1, Date date2, Date dateBetween, Object ... adicional) {
        this.valid(code, date1);
        this.valid(code, date2);
        if (date1 != null && date2 != null && !ToolDate.dateBetween((Date)dateBetween, (Date)date1, (Date)date2).booleanValue()) {
            this.newMessageItem(code, date1, date2);
            return false;
        }
        return true;
    }

    public boolean validAfterEqualMonthYear(ValidMessages.Code code, Date date1, Date date2, Object ... adicional) {
        this.valid(code, date1);
        this.valid(code, date2);
        if (date1 != null && date2 != null) {
            if (TDate.getYearFromDate((Date)date1) > TDate.getYearFromDate((Date)date2)) {
                this.newMessageItem(code, date1, date2);
                return false;
            }
            if (TDate.getYearFromDate((Date)date1) == TDate.getYearFromDate((Date)date2) && TDate.getMonthFromDate((Date)date1) > TDate.getMonthFromDate((Date)date2)) {
                this.newMessageItem(code, date1, date2);
                return false;
            }
        }
        return true;
    }

    public boolean validBeforeMonthYear(ValidMessages.Code code, Date date1, Date date2, Object ... adicional) {
        this.valid(code, date1);
        this.valid(code, date2);
        if (date1 != null && date2 != null) {
            if (TDate.getYearFromDate((Date)date1) > TDate.getYearFromDate((Date)date2)) {
                this.newMessageItem(code, date1, date2);
                return false;
            }
            if (TDate.getYearFromDate((Date)date1) == TDate.getYearFromDate((Date)date2) && TDate.getMonthFromDate((Date)date1) >= TDate.getMonthFromDate((Date)date2)) {
                this.newMessageItem(code, date1, date2);
            }
        }
        return true;
    }

    public boolean validBeforeWarn(ValidMessages.Code code, Date date1, Date date2, Object ... adicional) {
        this.validWarn(code, date1);
        this.validWarn(code, date2);
        if (date1 != null && date2 != null && date2.before(date1)) {
            this.newMessageItemWarn(code, (Object)date1, date2);
            return false;
        }
        return true;
    }

    public void valid(Date date1, Date date2, String messageCode, Object ... adicional) {
        if (date1 != null && date1.after(date2)) {
            this.newMessageItem(new ValidMessages.Code(messageCode, adicional), date1, date2);
        }
    }

    public boolean validBeforeEqual(ValidMessages.Code code, Date date1, Date date2, Object ... adicional) {
        this.valid(code, date1);
        this.valid(code, date2);
        if (date1 != null && date2 != null && !date1.before(date2) && !date1.equals(date2)) {
            this.newMessageItem(code, date1, date2);
            return false;
        }
        return true;
    }

    public boolean validBeforeEqualWarn(ValidMessages.Code code, Date date1, Date date2, Object ... adicional) {
        this.validWarn(code, date1);
        this.validWarn(code, date2);
        if (date1 != null && date2 != null && (date2.before(date1) || date2.equals(date1))) {
            this.newMessageItemWarn(code, (Object)date1, date2);
            return false;
        }
        return true;
    }

    public boolean validMaxLenght(ValidMessages.Code code, String value, int maxLength) {
        this.valid(code, value);
        if (value != null && value.length() > maxLength) {
            this.newMessageItem(code, value);
        }
        return true;
    }

    public boolean validMaxLenghtWarn(ValidMessages.Code code, String value, int maxLength) {
        this.validWarn(code, value);
        if (value != null && value.length() > maxLength) {
            this.newMessageItemWarn(code, value);
        }
        return true;
    }

    public boolean validLenght(ValidMessages.Code code, String value, int length, Object ... adicional) {
        code.setArgs(adicional);
        this.valid(code, value);
        if (value != null && value.length() != length) {
            this.newMessageItem(code, value);
            return false;
        }
        return true;
    }

    public boolean validLenghtWarn(ValidMessages.Code code, String value, int length) {
        this.validWarn(code, value);
        if (value != null && value.length() != length) {
            this.newMessageItemWarn(code, (Object)value, "V.ERP.0000.003");
            return false;
        }
        return true;
    }

    protected String getMessage(String messageCod, Object ... adicional) {
        return MessagesBaseMentor.getValidationMsg((String)messageCod, (Object[])adicional);
    }

    protected String getMessageError(String messageCod, Object ... adicional) {
        return MessagesBaseMentor.getMsg((String)messageCod, (Object[])adicional);
    }

    protected String getMessageWarn(String messageCod, Object ... adicional) {
        return MessagesBaseMentor.getMsg((String)messageCod, (Object[])adicional);
    }

    public ValidContainer getContainer() {
        return this.container;
    }

    public void clear() {
        this.getContainer().clear();
    }

    public TLogger getLogger() {
        return this.logger;
    }

    public void doLogError(Throwable t) {
        this.getLogger().error(t.getClass(), t);
    }

    public void clearContainer() {
        this.clearContainerErrors();
        this.clearContainerWarn();
    }

    public void clearContainerWarn() {
        this.containerWarns.clear();
    }

    public void clearContainerErrors() {
        this.container.clear();
    }

    public boolean hasErrors() {
        return !this.getContainer().getItens().isEmpty();
    }

    public boolean hasWarns() {
        return !this.getContainerWarns().getItens().isEmpty();
    }

    public ValidMessages.Code code(String code) {
        return ValidMessages.ofVal(code);
    }

    public ValidMessages.Code code(String code, String field) {
        return ValidMessages.ofVal(code, field);
    }

    public void valid(ValidMessages.Code code, String value, boolean permitirStrVazia) {
        if (value == null) {
            this.newMessageItem(code, value);
        }
        if (value != null && value.trim().isEmpty() && !permitirStrVazia) {
            this.newMessageItem(code, value);
        }
    }

    public ValidContainer getContainerWarns() {
        return this.containerWarns;
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public void setCurrentPos(int currentPos) {
        this.currentPos = currentPos;
    }

    public ValidMessages.Code code(String code, Object ... args) {
        return ValidMessages.ofVal(code, args);
    }

    public ValidMessages.Code code(Integer code, String field) {
        return ValidMessages.ofVal(code.toString(), field);
    }

    public ValidMessages.Code code(String code, String field, Object ... args) {
        return ValidMessages.ofVal(code, field, args);
    }

    public void addError(ValidMessages.Code code, Object value) {
        this.newMessageItemError(code, value);
    }

    public void addWarn(ValidMessages.Code code, Object value) {
        this.newMessageItemWarn(code, value);
    }

    public void buildResult(WebDTOResult w) {
        if (this.hasErrors()) {
            w.setStatus(EnumConstantsMentorStatus.ERRO);
            this.getContainer().getItens().forEach(i -> w.addErroMessage(i.getCodigo().getCode(), i.getDescricao(), i.getCodigo().getFieldName()));
        }
    }

    protected void newMessageItem(ValidMessages.Code code, Object value) {
        ValidContainerItem item = new ValidContainerItem(code, this.getMessage(code.getCode(), code.getArgs()), value);
        this.addItem(item, EnumValidacaoTipo.VALIDAR);
    }

    protected void newMessageItemWarn(ValidMessages.Code code, Object value) {
        ValidContainerItem item = new ValidContainerItem(code, this.getMessageWarn(code.getCode(), code.getArgs()), value);
        this.addItem(item, EnumValidacaoTipo.APENAS_AVISAR);
    }

    protected void newMessageItemError(ValidMessages.Code code, Object value) {
        ValidContainerItem item = new ValidContainerItem(code, this.getMessageError(code.getCode(), code.getArgs()), value);
        this.addItem(item, EnumValidacaoTipo.VALIDAR);
    }

    protected void newMessageItem(ValidMessages.Code code, Object value1, Object value2) {
        ValidContainerItem item = new ValidContainerItem(code, this.getMessage(code.getCode(), code.getArgs()), value1, value2);
        this.addItem(item, EnumValidacaoTipo.VALIDAR);
    }

    public void newMessageItemWarn(ValidMessages.Code code, Object value, String baseMessageCode) {
        ValidContainerItem item = new ValidContainerItem(code, this.getMessage(baseMessageCode, this.getMessage(code.getFieldName(), new Object[0])), value);
        this.addItem(item, EnumValidacaoTipo.APENAS_AVISAR);
    }

    public void newMessageItem(ValidMessages.Code code, Object value1, Object value2, String baseMessageCode) {
        ValidContainerItem item = new ValidContainerItem(code, this.getMessage(baseMessageCode, this.getMessage(code.getFieldName(), new Object[0])), value1, value2);
        this.addItem(item, EnumValidacaoTipo.VALIDAR);
    }

    protected void newMessageItemWarn(ValidMessages.Code code, Object value1, Object value2) {
        ValidContainerItem item = new ValidContainerItem(code, this.getMessage(code.getCode(), code.getArgs()), value1, value2);
        this.addItem(item, EnumValidacaoTipo.APENAS_AVISAR);
    }

    private void addItem(ValidContainerItem item, EnumValidacaoTipo tipo) {
        tipo = this.validChek.checkItem(item.getCodigo().getCode(), tipo);
        if (this.isEquals(EnumValidacaoTipo.APENAS_AVISAR, tipo)) {
            if (!this.getContainerWarns().getItens().contains(item)) {
                this.getContainerWarns().getItens().add(item);
            }
        } else if (this.isEquals(EnumValidacaoTipo.VALIDAR, tipo) && !this.getContainer().getItens().contains(item)) {
            this.getContainer().getItens().add(item);
        }
    }

    public void onGetBean() {
    }

    public void setContainer(ValidContainer container) {
        this.container = container;
    }

    public void setContainerWarns(ValidContainer containerWarns) {
        this.containerWarns = containerWarns;
    }
}

