/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.atareuniao;

import com.touchcomp.basementor.model.vo.AtaReuniao;
import com.touchcomp.basementor.model.vo.AtaReuniaoParticipante;
import com.touchcomp.basementor.model.vo.AtaReuniaoPauta;
import com.touchcomp.basementor.model.vo.AtaReuniaoRegVinculados;
import com.touchcomp.basementor.model.vo.AtaReuniaoVinculo;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidAtaReuniao
extends ValidGenericEntitiesImpl<AtaReuniao> {
    @Override
    protected void isValid(AtaReuniao vo) {
        this.valid(this.code("V.ERP.1941.002", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.1941.004", "dataReuniao"), vo.getDataReuniao());
        this.valid(this.code("V.ERP.1941.005", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.1941.006", "classificacaoAtaReuniao"), vo.getClassificacaoAtaReuniao());
        this.valid(this.code("V.ERP.1941.007", "cidade"), vo.getCidade());
        if (this.valid(this.code("V.ERP.1941.009", "pautas"), (Object)vo.getPautas())) {
            this.validarPautas(vo);
        }
        if (this.valid(this.code("V.ERP.1941.008", "participantes"), (Object)vo.getParticipantes())) {
            this.validarParticipantes(vo);
        }
        if (vo.getRegVinculados() != null) {
            this.validarRegVinculados(vo);
        }
        if (vo.getRegVinculados() != null) {
            this.validarRegVinculados(vo);
        }
        if (vo.getReunioesAnteriores() != null) {
            this.vaidarAtasAnteriores(vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validarPautas(AtaReuniao vo) {
        for (AtaReuniaoPauta pauta : vo.getPautas()) {
            this.valid(this.code("V.ERP.1941.010", "pautaReuniao"), pauta.getPautaReuniao());
        }
    }

    private void validarParticipantes(AtaReuniao vo) {
        for (AtaReuniaoParticipante pt : vo.getParticipantes()) {
            this.valid(this.code("V.ERP.1941.011", "nomeParticipante"), pt.getNomeParticipante());
            this.valid(this.code("V.ERP.1941.012", "tituloParticipante"), pt.getTituloParticipante());
            this.valid(this.code("V.ERP.1941.013", "documentoParticipante"), pt.getDocumentoParticipante());
        }
    }

    private void validarRegVinculados(AtaReuniao vo) {
        for (AtaReuniaoRegVinculados ret : vo.getRegVinculados()) {
            this.valid(this.code("V.ERP.1941.014", "entidade"), ret.getEntidade());
            this.valid(this.code("V.ERP.1941.015", "descricaoEntidade"), ret.getDescricaoEntidade());
            this.valid(this.code("V.ERP.1941.016", "idEntidade"), ret.getIdEntidade());
        }
    }

    private void vaidarAtasAnteriores(AtaReuniao vo) {
        for (AtaReuniaoVinculo r : vo.getReunioesAnteriores()) {
            this.valid(this.code("V.ERP.1941.017", "ataReuniaoAnterior"), r.getAtaReuniaoAnterior());
        }
    }
}

