/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.avaliadorexpressoes;

import com.touchcomp.basementor.model.vo.AvaliadorExpConstVar;
import com.touchcomp.basementor.model.vo.AvaliadorExpFormulas;
import com.touchcomp.basementor.model.vo.AvaliadorExpressoes;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.HashMap;
import org.springframework.stereotype.Component;

@Component
public class ValidAvaliadorExpressoes
extends ValidGenericEntitiesImpl<AvaliadorExpressoes> {
    @Override
    protected void isValid(AvaliadorExpressoes vo) {
        this.valid(this.code("V.ERP.1536.001", "descricao"), vo.getDescricao());
        this.validNotEmpty(this.code("V.ERP.1536.002", "formulas"), vo.getFormulas());
        this.validarFormulas(vo);
        this.validarVariaveis(vo);
        this.validarConstantes(vo);
    }

    private void validarFormulas(AvaliadorExpressoes vo) {
        if (vo.getFormulas() == null) {
            return;
        }
        for (AvaliadorExpFormulas form : vo.getFormulas()) {
            this.valid(this.code("V.ERP.1536.006", "descricao"), form.getDescricao());
            this.valid((Object)this.code("V.ERP.1536.004", "condAplicacao"), form.getCondAplicacao(), form.getDescricao());
            this.valid((Object)this.code("V.ERP.1536.005", "formula"), form.getFormula(), form.getDescricao());
        }
    }

    private void validarConstantes(AvaliadorExpressoes vo) {
        if (vo.getConstVariaveis() == null) {
            return;
        }
        for (AvaliadorExpConstVar varConst : vo.getConstVariaveis()) {
            this.valid(this.code("V.ERP.1536.007", "nome"), varConst.getNome());
            this.valid(this.code("V.ERP.1536.008", "valor", varConst.getNome()), varConst.getValor());
        }
    }

    private void validarVariaveis(AvaliadorExpressoes vo) {
        if (vo.getConstVariaveis() == null) {
            return;
        }
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (AvaliadorExpConstVar constVariavei : vo.getConstVariaveis()) {
            Integer count = (Integer)counter.get(constVariavei.getNome());
            if (count == null) {
                counter.put(constVariavei.getNome(), 1);
                continue;
            }
            Integer n = count;
            count = count + 1;
            if (count > 1) {
                this.addError(this.code("V.ERP.1536.003", "formulas", constVariavei.getNome()), constVariavei);
            }
            counter.put(constVariavei.getNome(), count);
        }
    }

    @Override
    public String getSimpleName() {
        return "1536 - Avalia\u00e7\u00e3o Express\u00f5es Pedidos";
    }
}

