/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.bombacombustivel;

import com.touchcomp.basementor.model.vo.BicoBombaCombustivel;
import com.touchcomp.basementor.model.vo.BombaCombustivel;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidBombaCombustivel
extends ValidGenericEntitiesImpl<BombaCombustivel> {
    @Override
    protected void isValid(BombaCombustivel vo) {
        this.valid(this.code("V.ERP.0846.001", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.0846.002", "bicos"), (Object)vo.getBicos());
        this.valid(this.code("V.ERP.0846.003", "lacres"), (Object)vo.getLacres());
        this.valid(this.code("V.ERP.0846.004", "numeroBomba"), vo.getNumeroBomba());
        this.valid(this.code("V.ERP.0846.005", "fabricante"), vo.getFabricante());
        this.valid(this.code("V.ERP.0846.006", "modelo"), vo.getModelo());
        this.valid(this.code("V.ERP.0846.007", "serie"), vo.getSerie());
        if (!this.diferecaCasasValida(vo).booleanValue()) {
            this.newMessageItem(this.code("V.ERP.0846.008"), vo.getNrCasasMedidor());
        }
        if (!this.dataDesativacaoValida(vo).booleanValue()) {
            this.newMessageItem(this.code("V.ERP.0846.009"), vo.getDataDesativacao());
        }
        if (vo.getBicos() != null) {
            for (BicoBombaCombustivel bico : vo.getBicos()) {
                this.valid(this.code("V.ERP.0846.010", "tanqueCombustivel"), bico.getTanqueCombustivel());
                this.valid(this.code("V.ERP.0846.011", "gradeCor"), bico.getGradeCor());
            }
        }
    }

    Boolean diferecaCasasValida(BombaCombustivel vo) {
        if (vo.getNrCasasMedidor() != null && vo.getNrCasasMedidorSuportada() != null && vo.getNrCasasMedidor() > 0 && vo.getNrCasasMedidor() - vo.getNrCasasMedidorSuportada() != 1) {
            return false;
        }
        return true;
    }

    Boolean dataDesativacaoValida(BombaCombustivel vo) {
        if (!this.isAffirmative(vo.getAtivo()) && vo.getDataDesativacao() == null) {
            return false;
        }
        return true;
    }

    @Override
    public String getSimpleName() {
        return "Bomba Combust\u00edvel";
    }
}

