/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.businessintelligence;

import com.touchcomp.basementor.constants.enums.businessintelligence.EnumConstBITipoGeracao;
import com.touchcomp.basementor.model.vo.BusinessIntConsHQL;
import com.touchcomp.basementor.model.vo.BusinessIntConsSQL;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceDados;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFiles;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceObjetos;
import com.touchcomp.basementor.model.vo.CheckNodeBI;
import com.touchcomp.basementor.model.vo.DadoAdicionalBI;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidBusinessIntelligence
extends ValidGenericEntitiesImpl<BusinessIntelligence> {
    @Override
    protected void isValid(BusinessIntelligence vo) {
        this.valid(this.code("V.ERP.0747.003", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.0747.025", "tipoTemplate"), vo.getTipoTemplate());
        if (vo.getBusinessIntelligenceObjetos() != null) {
            this.valid(this.code("V.ERP.0747.004", "businessIntelligenceObjetos.classeModeloBI"), vo.getBusinessIntelligenceObjetos().getClasseModeloBI());
            if (ToolMethods.isNotNull((Object)vo.getBusinessIntelligenceObjetos().getClasseModeloBI()).booleanValue()) {
                this.validNotEmpty(this.code("V.ERP.0747.005", "businessIntelligenceObjetos.classeModeloBI.nodosSelecao"), vo.getBusinessIntelligenceObjetos().getClasseModeloBI().getNodosSelecao());
                this.existeDescricaoRepetida(vo.getBusinessIntelligenceObjetos());
            }
        }
        if (vo.getTipoBI().shortValue() == EnumConstBITipoGeracao.TIPO_GERACAO_BI_CODIGO_JAVA.getValue()) {
            String content;
            this.valid(this.code("V.ERP.0747.008", "businessJavaClassCode"), vo.getBusinessJavaClassCode());
            this.valid(this.code("V.ERP.0747.009", "businessJavaClassCode.classPackage"), vo.getBusinessJavaClassCode().getClassPackage());
            this.valid(this.code("V.ERP.0747.008", "businessJavaClassCode.classContent"), vo.getBusinessJavaClassCode().getClassContent());
            this.valid(this.code("V.ERP.0747.010", "businessJavaClassCode.byteCodeClass"), vo.getBusinessJavaClassCode().getByteCodeClass());
            if (vo.getDataCadastro() != null && vo.getDataCadastro().after(ToolDate.strToDate((String)"01/07/2021")) && vo.getBusinessJavaClassCode().getClassContent() != null && ((content = new String(vo.getBusinessJavaClassCode().getClassContent())).contains(" mentor.") || content.contains(" mentorcore."))) {
                this.addError(this.code("V.ERP.0747.011", "businessJavaClassCode.classContent"), vo.getBusinessJavaClassCode().getByteCodeClass());
            }
        }
        if (vo.getTipoBI().shortValue() == EnumConstBITipoGeracao.TIPO_GERACAO_BI_SQL.getValue()) {
            this.valid(this.code("V.ERP.0747.012", "businessIntConsSQL.query"), vo.getBusinessIntConsSQL().getQuery());
            this.validarQuerySql(vo.getBusinessIntConsSQL().getConsultasSQL());
        }
        if (vo.getTipoBI().shortValue() == EnumConstBITipoGeracao.TIPO_GERACAO_BI_HIBERNATE.getValue()) {
            this.valid(this.code("V.ERP.0747.013", "businessIntConsHQL.query"), vo.getBusinessIntConsHQL().getQuery());
            this.validarQueryHql(vo.getBusinessIntConsHQL().getConsultasHQL());
        }
        if (vo.getBusinessIntelligenceInf().getTipoImpressora() == 1) {
            this.valid(this.code("V.ERP.0747.014", "businessIntelligenceInf.nomeImpressora"), vo.getBusinessIntelligenceInf().getNomeImpressora());
        }
        if (this.valid(this.code("V.ERP.0747.015", "businessIntelligenceFiles"), (Object)vo.getBusinessIntelligenceFiles())) {
            this.validarArquivos(vo);
        }
        if (this.valid(this.code("V.ERP.0747.016", "dataInicial"), (Object)vo.getDadosAdicionalBI())) {
            this.validarDadosAdicionais(vo);
        }
        if (this.valid(this.code("V.ERP.0747.017", "dataInicial"), (Object)vo.getDadosImagens())) {
            this.validarDadosAdicionaisImagens(vo);
        }
    }

    private void existeDescricaoRepetida(BusinessIntelligenceObjetos vo) {
        ArrayList aux = new ArrayList(vo.getClasseModeloBI().getNodosSelecao());
        for (CheckNodeBI c : vo.getClasseModeloBI().getNodosSelecao()) {
            this.valid(this.code("V.ERP.0747.006", "businessIntelligenceObjetos.classeModeloBI.nodosSelecao.descricao", c.getAtributo()), c.getDescricao());
            for (CheckNodeBI d : aux) {
                if (d.equals((Object)c) || !c.getDescricao().equals(d.getDescricao())) continue;
                this.addError(this.code("V.ERP.0747.007", "businessIntelligenceObjetos.classeModeloBI.nodosSelecao.descricao", c.getAtributo()), c.getDescricao());
            }
        }
    }

    private boolean validarQueryHql(List<BusinessIntConsHQL> sql) {
        for (BusinessIntConsHQL bo : sql) {
            if (ToolMethods.isStrWithData((String)bo.getQuery())) continue;
            this.addError(this.code("V.ERP.0747.013", "businessIntConsHQL.query", bo.getNome()), bo.getQuery());
            return false;
        }
        return true;
    }

    private boolean validarQuerySql(List<BusinessIntConsSQL> sql) {
        for (BusinessIntConsSQL bo : sql) {
            if (ToolMethods.isStrWithData((String)bo.getQuery())) continue;
            this.addError(this.code("V.ERP.0747.012", "businessIntConsHQL.query", bo.getNome()), bo.getQuery());
            return false;
        }
        return true;
    }

    private void validarArquivos(BusinessIntelligence vo) {
        for (BusinessIntelligenceFiles b : vo.getBusinessIntelligenceFiles()) {
            this.valid(this.code("V.ERP.0747.018", "businessIntelligenceFiles.nome"), b.getNome());
            this.valid(this.code("V.ERP.0747.019", "businessIntelligenceFiles.sourceJrxml", b.getNome()), b.getSourceJrxml());
            this.valid(this.code("V.ERP.0747.020", "businessIntelligenceFiles.sourceJasper", b.getNome()), b.getSourceJasper());
        }
        HashSet<String> layout = new HashSet<String>();
        for (BusinessIntelligenceFiles ff : vo.getBusinessIntelligenceFiles()) {
            layout.add(ff.getChaveLayout());
        }
        for (String chaveLayout : layout) {
            int qtd = vo.getBusinessIntelligenceFiles().stream().mapToInt(j -> TMethods.isEquals((Object)chaveLayout, (Object)j.getChaveLayout()) && TMethods.isAffirmative((Number)j.getArquivoPrincipal()) ? 1 : 0).sum();
            if (qtd <= 1) continue;
            this.addError(this.code("V.ERP.0747.021", "businessIntelligenceFiles.arquivoPrincipal", chaveLayout), chaveLayout);
        }
    }

    private void validarDadosAdicionais(BusinessIntelligence vo) {
        for (DadoAdicionalBI o : vo.getDadosAdicionalBI()) {
            this.valid(this.code("V.ERP.0747.022", "dadosAdicionalBI.descricaoParametro"), o.getDescricaoParametro());
            if (o.getPermitirAlterarValor() != 0) continue;
            this.valid(this.code("V.ERP.0747.023", "dadosAdicionalBI.valorParametro"), o.getValorParametro());
        }
    }

    private void validarDadosAdicionaisImagens(BusinessIntelligence vo) {
        for (BusinessIntelligenceDados o : vo.getDadosImagens()) {
            this.valid(this.code("V.ERP.0747.024", "dadosImagens.descricao"), o.getDescricao());
        }
    }

    @Override
    public String getSimpleName() {
        return "747";
    }
}

