/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.cliente;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ClienteFinanceiroFornecedor;
import com.touchcomp.basementor.model.vo.ClienteFinanceiroSocioAutorizado;
import com.touchcomp.basementor.model.vo.ClienteNFCe;
import com.touchcomp.basementor.model.vo.TransportadorPraca;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.pessoa.ValidPessoa;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidCliente
extends ValidGenericEntitiesImpl<Cliente> {
    @Autowired
    ValidPessoa validPessoa;

    @Override
    protected void isValid(Cliente vo) {
        if (this.valid(this.code("V.ERP.0076.001", "pessoa"), vo.getPessoa())) {
            this.valid((ValidGenericEntitiesImpl)this.validPessoa, (InterfaceVO)vo.getPessoa());
            if (TMethods.isNotNull((Object)vo.getPessoa()).booleanValue()) {
                EnumConstUF uf;
                if (vo.getPessoa().getEndereco().getCidade() != null && !(uf = EnumConstUF.valueOfSigla((String)vo.getPessoa().getEndereco().getCidade().getUf().getSigla())).isExterior()) {
                    this.valid(this.code("V.ERP.0076.002", "cnpj"), vo.getPessoa().getComplemento().getCnpj());
                }
                this.valid(this.code("V.ERP.0076.003", "contribuinteEstado"), vo.getPessoa().getComplemento().getContribuinteEstado());
                if (!this.isEquals(vo.getPessoa().getComplemento().getContribuinteEstado(), EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId())) {
                    this.valid(this.code("V.ERP.0076.004", "inscricaoEstadual"), vo.getPessoa().getComplemento().getInscEst());
                }
                if (this.isAffirmative(vo.getAtivo()) && !this.isAffirmative(vo.getPessoa().getAtivo())) {
                    this.addError(this.code("V.ERP.0076.006", "ativo"), vo.getPessoa());
                }
            }
            this.validarPracaTransportador(vo);
        }
        this.valid(this.code("V.ERP.0076.007", "classificacaoClientes"), vo.getClassificacaoClientes());
        this.valid(this.code("V.ERP.0076.008", "regiao"), vo.getRegiao());
        this.valid(this.code("V.ERP.0076.009", "nome"), vo.getFinanceiro());
        if (this.valid(this.code("V.ERP.0076.010", "faturamento"), vo.getFaturamento())) {
            this.valid(this.code("V.ERP.0076.011", "representante"), vo.getFaturamento().getRepresentante());
            this.valid(this.code("V.ERP.0076.012", "tipoFrete"), vo.getFaturamento().getTipoFrete());
            this.valid(this.code("V.ERP.0076.013", "categoriaPessoa"), vo.getFaturamento().getCategoriaPessoa());
        }
        if (this.validNotEmpty(this.code("V.ERP.0076.014", "unidadeFatCliente"), vo.getUnidadeFatClientes())) {
            this.validarUnidades(vo);
        }
        this.valid(this.code("V.ERP.0076.019", "fichaFinanceira"), vo.getFichaFinanceira());
        if (TMethods.isNotNull((Object)vo.getFichaFinanceira()).booleanValue() && TMethods.isWithData((Collection)vo.getFichaFinanceira().getFornecedores())) {
            this.validarFornecedores(vo);
            this.validarSocios(vo);
        }
        if (TMethods.isWithData((Collection)vo.getClienteNFCe())) {
            this.validarClienteNFCe(vo);
        }
        if (TMethods.isNotNull((Object)this.getSharedObjects().getOpcoesRelacionamento(vo.getEmpresa())).booleanValue() && this.isAffirmative(this.getSharedObjects().getOpcoesRelacionamento(vo.getEmpresa()).getObrigarEmailCliente())) {
            this.validNotEmpty(this.code("V.ERP.0076.022", "emails"), vo.getPessoa().getComplemento().getEmails());
        }
    }

    private void validarPracaTransportador(Cliente vo) {
        if (TMethods.isNotNull((Object)vo.getFaturamento()).booleanValue() && TMethods.isNotNull((Object)vo.getFaturamento().getTransportadora()).booleanValue() && TMethods.isWithData((Collection)vo.getFaturamento().getTransportadora().getPraca())) {
            Boolean atende = false;
            for (TransportadorPraca tp : vo.getFaturamento().getTransportadora().getPraca()) {
                if (vo.getPessoa().getEndereco().getCidade() == null || !TMethods.isEquals((Object)tp.getUf(), (Object)vo.getPessoa().getEndereco().getCidade().getUf())) continue;
                atende = true;
                break;
            }
            if (!atende.booleanValue()) {
                this.addError(this.code("V.ERP.0076.005", "transportadora"), vo.getFaturamento().getTransportadora());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "76 - Clientes";
    }

    private void validarUnidades(Cliente vo) {
        int countUnidadeFatPadrao = 0;
        Boolean catClienteUnidadeIgual = true;
        for (UnidadeFatCliente unid : vo.getUnidadeFatClientes()) {
            this.valid(this.code("V.ERP.0076.015", "categoriaPessoa"), unid.getCategoriaPessoa());
            if (this.isAffirmative(unid.getUnidadeFatPadrao())) {
                ++countUnidadeFatPadrao;
            }
            if (!this.isEquals(unid.getCategoriaPessoa(), vo.getFaturamento().getCategoriaPessoa())) continue;
            catClienteUnidadeIgual = false;
        }
        if (catClienteUnidadeIgual.booleanValue()) {
            this.addError(this.code("V.ERP.0076.016", "categoriaPessoa"), vo.getPessoa());
        }
        if (countUnidadeFatPadrao == 0) {
            this.addError(this.code("V.ERP.0076.017", "nome"), vo.getPessoa());
        }
        if (countUnidadeFatPadrao > 1) {
            this.addError(this.code("V.ERP.0076.018", "nome"), vo.getPessoa());
        }
    }

    private void validarFornecedores(Cliente vo) {
        for (ClienteFinanceiroFornecedor fornecedor : vo.getFichaFinanceira().getFornecedores()) {
            this.valid(this.code("V.ERP.0076.020", "nome"), fornecedor.getNomeFornecedor());
            this.valid(this.code("V.ERP.0076.020", "fone"), fornecedor.getFoneFornecedor());
        }
    }

    private void validarSocios(Cliente vo) {
        for (ClienteFinanceiroSocioAutorizado socio : vo.getFichaFinanceira().getSociosAutorizadas()) {
            this.valid(this.code("V.ERP.0076.023", "nome"), socio.getNomeSocio());
        }
    }

    private void validarClienteNFCe(Cliente vo) {
        boolean isCNPJ = ValidadeCPFCNPJ.isCNPJ(vo.getPessoa().getComplemento().getCnpj());
        for (ClienteNFCe c : vo.getClienteNFCe()) {
            if (isCNPJ && this.isEquals(c.getTipoFaturamento(), (short)0) || this.isEquals(c.getTipoFaturamento(), (short)2)) {
                this.addError(this.code("V.ERP.0076.021", "nome"), vo.getPessoa());
            }
            this.valid(this.code("V.ERP.0076.024", "empresa"), c.getEmpresa());
        }
    }
}

