/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.complemento;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.TelefonePessoa;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.basementorvalidator.others.email.ValidateEmail;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidComplemento
extends ValidGenericEntitiesImpl<Complemento> {
    @Override
    protected void isValid(Complemento vo) {
        if (TMethods.isStrWithData((String)vo.getFone1())) {
            this.validOnlyNumbers(this.code("V.ERP.0047.201", "fone1"), vo.getFone1());
            this.validMaxLenght(this.code("V.ERP.0047.201", "fone1", vo.getFone1()), vo.getFone1(), 14);
        }
        if (TMethods.isStrWithData((String)vo.getFone2())) {
            this.validOnlyNumbers(this.code("V.ERP.0047.202", "fone2"), vo.getFone2());
            this.validMaxLenght(this.code("V.ERP.0047.202", "fone2", vo.getFone2()), vo.getFone2(), 14);
        }
        if (TMethods.isStrWithData((String)vo.getCel1())) {
            this.validOnlyNumbers(this.code("V.ERP.0047.203", "cel1"), vo.getCel1());
            this.validMaxLenght(this.code("V.ERP.0047.203", "fone1", vo.getCel1()), vo.getCel1(), 14);
        }
        if (TMethods.isStrWithData((String)vo.getCel2())) {
            this.validOnlyNumbers(this.code("V.ERP.0047.204", "cel2"), vo.getCel2());
            this.validMaxLenght(this.code("V.ERP.0047.204", "fone1", vo.getCel2()), vo.getCel2(), 14);
        }
        if (this.valid(this.code("V.ERP.0047.205", "outrosTelefones"), (Object)vo.getOutrosTelefones())) {
            this.validarOutrosTelefones(vo.getOutrosTelefones());
        }
        if (ToolMethods.isStrWithData((String)vo.getCnpj()) && !ValidadeCPFCNPJ.isValid(vo.getCnpj())) {
            this.addError(this.code("V.ERP.0047.209", "cnpj"), vo.getCnpj());
        }
        this.validarInscEst(vo);
        this.validarInscSuframa(vo);
        this.validarEmails(vo);
    }

    @Override
    public String getSimpleName() {
        return "complemento";
    }

    private void validarOutrosTelefones(List<TelefonePessoa> outrosTelefones) {
        for (TelefonePessoa out : outrosTelefones) {
            if (!TMethods.isStrWithData((String)out.getTelefone())) continue;
            this.validOnlyNumbers(this.code("V.ERP.0047.206", "outrosTelefones"), out.getTelefone());
            this.validMaxLenght(this.code("V.ERP.0047.204", "outrosTelefones", out.getTelefone()), out.getTelefone(), 14);
        }
    }

    private void validarInscEst(Complemento vo) {
        this.valid(this.code("V.ERP.0047.210", "contribuinteEstado"), vo.getContribuinteEstado());
        if (this.isEquals(vo.getContribuinteEstado(), EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId())) {
            this.valid(this.code("V.ERP.0047.211", "inscEst"), vo.getInscEst());
            if (ToolMethods.isNotNull((Object)vo.getInscEst()).booleanValue()) {
                this.validMinMax(this.code("V.ERP.0047.216"), vo.getInscEst().length(), 2, 14);
            }
        }
    }

    private void validarInscSuframa(Complemento vo) {
        this.valid(this.code("V.ERP.0047.212", "habilitarSuframa"), vo.getHabilitarSuframa());
        if (this.isAffirmative(vo.getHabilitarSuframa())) {
            this.valid(this.code("V.ERP.0047.213", "suframa"), vo.getSuframa());
        }
    }

    private void validarEmails(Complemento vo) {
        if (this.valid(this.code("V.ERP.0047.214", "emails"), (Object)vo.getEmails())) {
            for (EmailPessoa email : vo.getEmails()) {
                if (!TMethods.isAffirmative((Number)email.getAtivo()) || ValidateEmail.isValid(email.getEmail())) continue;
                this.addError(this.code("V.ERP.0047.215", "email", email.getEmail()), email.getEmail());
            }
        }
    }
}

