/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.complemento;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.ComplementoTranspRedes;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.basementorvalidator.others.email.ValidateEmail;
import org.springframework.stereotype.Component;

@Component
public class ValidComplementoTranspRedes
extends ValidGenericEntitiesImpl<ComplementoTranspRedes> {
    @Override
    public String getSimpleName() {
        return "Complemento Transportador Redespacho";
    }

    @Override
    protected void isValid(ComplementoTranspRedes vo) {
        if (TMethods.isStrWithData((String)vo.getFone1())) {
            this.validOnlyNumbers(this.code("V.ERP.0069.005", "fone1"), vo.getFone1());
            this.validMaxLenght(this.code("V.ERP.0069.005", "fone1", vo.getFone1()), vo.getFone1(), 11);
        }
        if (TMethods.isStrWithData((String)vo.getFone2())) {
            this.validOnlyNumbers(this.code("V.ERP.0069.006", "fone2"), vo.getFone2());
            this.validMaxLenght(this.code("V.ERP.0069.006", "fone2", vo.getFone2()), vo.getFone2(), 11);
        }
        if (TMethods.isStrWithData((String)vo.getCel1())) {
            this.validOnlyNumbers(this.code("V.ERP.0069.007", "cel1"), vo.getCel1());
            this.validMaxLenght(this.code("V.ERP.0069.007", "fone1", vo.getCel1()), vo.getCel1(), 11);
        }
        if (TMethods.isStrWithData((String)vo.getCel2())) {
            this.validOnlyNumbers(this.code("V.ERP.0069.008", "cel2"), vo.getCel2());
            this.validMaxLenght(this.code("V.ERP.0069.008", "fone1", vo.getCel2()), vo.getCel2(), 11);
        }
        if (TMethods.isStrWithData((String)vo.getFax1())) {
            this.validOnlyNumbers(this.code("V.ERP.0069.009", "fax1"), vo.getFax1());
            this.validMaxLenght(this.code("V.ERP.0069.009", "fax1", vo.getFax1()), vo.getFax1(), 11);
        }
        if (TMethods.isStrWithData((String)vo.getFax2())) {
            this.validOnlyNumbers(this.code("V.ERP.0069.010", "fax2"), vo.getFax2());
            this.validMaxLenght(this.code("V.ERP.0069.010", "fax2", vo.getFax2()), vo.getFax2(), 11);
        }
        this.validarCnpj(vo);
        this.validarEmail(vo);
    }

    private void validarCnpj(ComplementoTranspRedes vo) {
        if (TMethods.isStrWithData((String)vo.getCnpj())) {
            if (!ValidadeCPFCNPJ.isValid(vo.getCnpj())) {
                this.addError(this.code("V.ERP.0069.011", "cnpj", vo.getCnpj()), vo.getCnpj());
            }
            if (vo.getCnpj().length() == 11) {
                vo.setTipoPessoa(EnumConstTipoPessoaComplementar.FISICA.getEnumId());
            } else if (vo.getCnpj().length() == 14) {
                vo.setTipoPessoa(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId());
            }
        } else {
            this.addError(this.code("V.ERP.0069.020", "cnpj", vo.getCnpj()), vo.getCnpj());
        }
    }

    private void validarEmail(ComplementoTranspRedes vo) {
        if (TMethods.isStrWithData((String)vo.getEmail()) && !ValidateEmail.isValid(vo.getEmail())) {
            this.addError(this.code("V.ERP.0069.012", "email", vo.getEmail()), vo.getEmail());
        }
    }
}

