/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.conciliacaobancaria;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ConciliacaoBancaria;
import com.touchcomp.basementor.model.vo.ConciliacaoBancariaDia;
import com.touchcomp.basementor.model.vo.ItemConciliacaoExtrato;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class ValidConciliacaoBancaria
extends ValidGenericEntitiesImpl<ConciliacaoBancaria> {
    @Override
    protected void isValid(ConciliacaoBancaria vo) {
        this.valid(this.code("V.ERP.1671.001"), vo.getDataInicial());
        this.valid(this.code("V.ERP.1671.002"), vo.getDataFinal());
        if (TMethods.isNull((Object)vo.getDataInicial()).booleanValue() && TMethods.isNull((Object)vo.getDataFinal()).booleanValue()) {
            this.validBefore(this.code("V.ERP.1671.003"), vo.getDataInicial(), vo.getDataFinal(), new Object[0]);
        }
        this.valid(this.code("V.ERP.1671.004"), vo.getContaValores());
        this.validNotEmpty(this.code("V.ERP.1671.006"), vo.getConciliacaoBancariaDia());
        this.validarItens(vo);
    }

    private void validarItens(ConciliacaoBancaria vo) {
        if (TMethods.isWithData((Collection)vo.getConciliacaoBancariaDia())) {
            for (ConciliacaoBancariaDia c : vo.getConciliacaoBancariaDia()) {
                Double totalExtrato = 0.0;
                Double totalMovimentos = 0.0;
                for (ItemConciliacaoExtrato i : c.getItemConciliacaoExtrato()) {
                    this.validNotEquals(this.code("V.ERP.1671.007", ToolDate.dateToStr((Date)i.getDataMovimento())), i.getConciliado(), EnumConstantsMentorSimNao.SIM.getValue());
                    totalExtrato = totalExtrato + i.getValor();
                }
                for (ItemConciliacaoExtrato i : c.getItemConciliacaoMovimento()) {
                    this.validNotEquals(this.code("V.ERP.1671.008", ToolDate.dateToStr((Date)i.getDataMovimento())), i.getConciliado(), EnumConstantsMentorSimNao.SIM.getValue());
                    totalMovimentos = totalMovimentos + i.getMovimentoBancario().getValor();
                }
                if (this.isEquals(ToolFormatter.arrredondarNumero((Double)totalExtrato, (int)2), ToolFormatter.arrredondarNumero((Double)totalMovimentos, (int)2))) continue;
                this.addError(this.code("V.ERP.1671.011", ToolDate.dateToStr((Date)c.getDataMovimento())), vo);
            }
        }
    }

    public void validarConciliacao(ConciliacaoBancaria vo) {
        if (TMethods.isWithData((Collection)vo.getConciliacaoBancariaDia())) {
            for (ConciliacaoBancariaDia c : vo.getConciliacaoBancariaDia()) {
                Double valorCreditosExtrato = ToolFormatter.arrredondarNumero((Double)c.getValorCreditosExtrato(), (int)2);
                Double valorCreditosMov = ToolFormatter.arrredondarNumero((Double)c.getValorCreditosMov(), (int)2);
                this.validNotEqualsWarn(this.code("V.ERP.1671.009"), valorCreditosExtrato, valorCreditosMov);
                Double valorDebitosExtrato = ToolFormatter.arrredondarNumero((Double)c.getValorDebitosExtrato(), (int)2);
                Double valorDebitosMov = ToolFormatter.arrredondarNumero((Double)c.getValorDebitosMov(), (int)2);
                this.validNotEqualsWarn(this.code("V.ERP.1671.010"), valorDebitosExtrato, valorDebitosMov);
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "1671 - Concilia\u00e7\u00e3o Banc\u00e1ria";
    }
}

