/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.condicoesambientaistrabalho;

import com.touchcomp.basementor.constants.enums.parametrizacaoambientetrabalhofuncao.EnumParametrizacaoAmbienteTrabalhoFuncao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.EsocCondAmbTrabMedico;
import com.touchcomp.basementor.model.vo.EsocCondicoesAmbientaisTrabalho;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidEsocCondicoesAmbientaisTrabalho
extends ValidGenericEntitiesImpl<EsocCondicoesAmbientaisTrabalho> {
    @Override
    public String getSimpleName() {
        return "1742 - Condi\u00e7\u00f5es Ambientais do Trabalho";
    }

    @Override
    protected void isValid(EsocCondicoesAmbientaisTrabalho entity) {
        this.valid(this.code("V.ERP.1742.001"), entity.getDataInicio());
        this.valid(this.code("V.ERP.1742.002"), entity.getColaborador());
        this.validNotEmpty(this.code("V.ERP.1742.003"), entity.getEsocCondAmbTrabAmbTrab());
        this.valid(this.code("V.ERP.1742.004"), entity.getDescricaoAtividades());
        this.validNotEmpty(this.code("V.ERP.1742.005"), entity.getEsocCondAmbTrabAtivid());
        this.validNotEmpty(this.code("V.ERP.1742.006"), entity.getEsocCondAmbTrabFatRisco());
        this.valid(this.code("V.ERP.1742.007"), entity.getEsocUtilizaEpc());
        this.valid(this.code("V.ERP.1742.008"), entity.getEsocUtilizaEpi());
        this.valid(this.code("V.ERP.1742.009"), (Object)entity.getEsocCondAmbTrabMedico());
        this.validMedico(entity.getEsocCondAmbTrabMedico());
        this.validTipoDescricao(entity);
        this.validBefore(this.code("V.ERP.1742.013"), entity.getColaborador().getDataAdmissao(), entity.getDataInicio(), new Object[0]);
    }

    public void validMedico(List<EsocCondAmbTrabMedico> esocCondAmbTrabMedico) {
        if (TMethods.isWithData(esocCondAmbTrabMedico)) {
            for (EsocCondAmbTrabMedico medico : esocCondAmbTrabMedico) {
                if (!this.isEquals(medico.getEsocCadastroMedicoResponsavel().getPessoa().getComplemento().getTipoPessoa(), EnumConstTipoPessoaComplementar.FISICA.getEnumId())) continue;
                String cpf = medico.getEsocCadastroMedicoResponsavel().getPessoa().getComplemento().getCnpj();
                this.validLenght(this.code("V.ERP.1742.010"), cpf, 11, medico.getEsocCadastroMedicoResponsavel().getPessoa().getNome());
            }
        }
    }

    public void validTipoDescricao(EsocCondicoesAmbientaisTrabalho entity) {
        if (this.isEquals(entity.getInformarDescricao(), EnumParametrizacaoAmbienteTrabalhoFuncao.ESOC_COND_AMB_TRAB_METODOLOGIA.value)) {
            this.valid(this.code("V.ERP.1742.011"), entity.getDescricaoMetodologia());
        } else {
            this.valid(this.code("V.ERP.1742.012"), entity.getObservacaoComplementar());
        }
    }
}

