/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.condicoespagamento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidCondicoesPagamento
extends ValidGenericEntitiesImpl<CondicoesPagamento> {
    @Override
    protected void isValid(CondicoesPagamento vo) {
        this.valid(this.code("V.ERP.0104.001", "nome"), vo.getNome());
        if (ToolMethods.isNull((Object)vo.getCondMutante()).booleanValue() || !this.isEquals(vo.getCondMutante(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.validGreather0(this.code("V.ERP.0104.002", "numeroParcelas"), vo.getNumeroParcelas());
            this.valid(this.code("V.ERP.0104.003", "numeroDiasVencimento"), vo.getNumeroDiasVencimento());
        } else if (this.isEquals(vo.getMutanteFixa(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.validGreather0(this.code("V.ERP.0104.004", "parcelasMutante"), ToolString.splitString((String)vo.getParcelasMutante(), (char[])new char[0]).length);
        } else {
            this.validGreather0(this.code("V.ERP.0104.005", vo.getNrMaximoDiasMedios()), vo.getNrMaximoDiasMedios());
        }
        this.valid(this.code("V.ERP.0104.006"), vo.getTpCondicao());
        this.valid(this.code("V.ERP.0104.007"), vo.getMeioPagamento());
        this.validEquals(this.code("V.ERP.0104.008"), vo.getAtivo(), EnumConstantsMentorSimNao.NAO.getValue());
        if (ToolMethods.isNull((Object)vo.getDiaSemana()).booleanValue() && this.isEquals(vo.getForcarData(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.addError(this.code("V.ERP.0104.009"), vo.getDiaSemana());
        }
        if (ToolMethods.isNotNull((Object)vo.getMeioPagamento()).booleanValue() && this.isEquals(vo.getMeioPagamento().getTipoPagamentoNFe().getCodigo(), EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo())) {
            if (this.isEquals(vo.getDataFixa(), EnumConstantsMentorSimNao.SIM.getValue()) && (ToolMethods.isNull((Object)vo.getDiaFixo()).booleanValue() || vo.getDiaFixo() == 0)) {
                this.addError(this.code("V.ERP.0104.010"), vo.getDataFixa());
            }
            if (this.isEquals(vo.getDataFixa(), EnumConstantsMentorSimNao.NAO.getValue()) && (ToolMethods.isNull((Object)vo.getDiaVariavel()).booleanValue() || vo.getDiaVariavel() == 0)) {
                this.addError(this.code("V.ERP.0104.011"), vo.getDiaVariavel());
            }
        }
        if (ToolMethods.isNotNull((Object)vo.getMeioPagamento()).booleanValue() && this.isEquals(vo.getMeioPagamento().getTipoPagamentoNFe().getCodigo(), EnumConstNFeTipoPagNFe.PIX.getCodigo())) {
            this.valid(this.code("V.ERP.0104.012"), vo.getContaValorPix());
        }
    }

    @Override
    public String getSimpleName() {
        return "104 - Condi\u00e7\u00f5es Pagamento";
    }
}

