/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.contagemprodutos;

import com.touchcomp.basementor.model.vo.ContagemProdCentroEstoque;
import com.touchcomp.basementor.model.vo.ContagemProdGrade;
import com.touchcomp.basementor.model.vo.ContagemProdProduto;
import com.touchcomp.basementor.model.vo.ContagemProdutos;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidContagemProdutos
extends ValidGenericEntitiesImpl<ContagemProdutos> {
    @Override
    protected void isValid(ContagemProdutos vo) {
        this.valid(this.code("V.ERP.1961.001"), vo.getEmpresa());
        this.valid(this.code("V.ERP.1961.002"), vo.getUsuario());
        this.valid(this.code("V.ERP.1961.003"), vo.getDescricao());
        this.valid(this.code("V.ERP.1961.004"), vo.getStatus());
        this.valid(this.code("V.ERP.1961.005"), vo.getDataContagem());
        if (this.validNotEmpty(this.code("V.ERP.1961.006"), vo.getCentrosEstoqueContagem())) {
            this.validCentrosEstocagem(vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validCentrosEstocagem(ContagemProdutos vo) {
        for (ContagemProdCentroEstoque cc : vo.getCentrosEstoqueContagem()) {
            this.valid(this.code("V.ERP.1961.007"), cc.getCentroEstoque());
            if (!this.validNotEmpty(this.code("V.ERP.1961.008", cc.getCentroEstoque()), cc.getProdutosContagem())) continue;
            this.validProdutosContagem(cc);
        }
    }

    private void validProdutosContagem(ContagemProdCentroEstoque vo) {
        for (ContagemProdProduto prod : vo.getProdutosContagem()) {
            this.valid(this.code("V.ERP.1961.009", vo.getCentroEstoque()), prod.getProduto());
            if (!this.validNotEmpty(this.code("V.ERP.1961.010", prod.getProduto()), prod.getGradesLotesContados())) continue;
            this.validProdutosContagem(prod);
        }
    }

    private void validProdutosContagem(ContagemProdProduto prod) {
        for (ContagemProdGrade gc : prod.getGradesLotesContados()) {
            this.valid(this.code("V.ERP.1961.011", prod.getProduto()), gc.getGradeCor());
            this.valid(this.code("V.ERP.1961.012", prod.getProduto()), gc.getLotefabricacao());
            this.valid(this.code("V.ERP.1961.013", prod.getProduto()), gc.getQuantidadeContada());
            this.valid(this.code("V.ERP.1961.014", prod.getProduto()), gc.getQuantidadeContada());
        }
    }
}

