/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.cotacaocompra;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.ValidImpl;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.touchvomodel.vo.cotacaocompra.web.DTOCotacaoCompra;
import com.touchcomp.touchvomodel.web.WebDTOInputObject;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidCotacaoCompra
extends ValidGenericEntitiesImpl<CotacaoCompra> {
    @Override
    protected void isValid(CotacaoCompra vo) {
        OpcoesCompraSuprimentos opcoesCompraSuprimentos;
        this.valid(this.code("V.ERP.1066.016"), vo.getDataCotacaoCompra());
        this.valid(this.code("V.ERP.1066.017"), vo.getDataPrevFinalizacao());
        if (this.validNotEmpty(this.code("V.ERP.1066.019"), vo.getItensCotacaoCompra())) {
            vo.getItensCotacaoCompra().forEach(i -> this.validItemCotacao((ItemCotacaoCompra)i));
        }
        if (ToolMethods.isNotNull((Object)vo.getEmpresa()).booleanValue() && ToolMethods.isNotNull((Object)this.getSharedObjects()).booleanValue() && ToolMethods.isNotNull((Object)(opcoesCompraSuprimentos = this.getSharedObjects().getOpcoesCompraSuprimentos(vo.getEmpresa()))).booleanValue() && this.isEquals(opcoesCompraSuprimentos.getInformarSituacaoCotacaoCompra(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.valid(this.code("V.ERP.1066.018"), vo.getSituacaoCotacaoCompra());
        }
    }

    private void validItemCotacao(ItemCotacaoCompra i) {
        OpcoesGerenciais opcoesGerenciais;
        this.valid(this.code("V.ERP.1066.001"), i.getGradeCor());
        this.valid(this.code("V.ERP.1066.003"), i.getNaturezaOperacao());
        this.valid(this.code("V.ERP.1066.002"), i.getUnidadeMedida());
        this.validGreather0(this.code("V.ERP.1066.020"), i.getFatorConversao());
        this.validGreather0(this.code("V.ERP.1066.021"), i.getQuantidade());
        if (ToolMethods.isNotNull((Object)i.getGerarReqLancarNota()).booleanValue() && this.isEquals(i.getGerarReqLancarNota(), EnumConstantsMentorSimNao.SIM.getValue())) {
            if (ToolMethods.isNotNull((Object)i.getCotacaoCompra().getEmpresa()).booleanValue() && ToolMethods.isNotNull((Object)i.getCotacaoCompra().getEmpresa().getEmpresaDados().getLancarCtoCustoEntrada()).booleanValue() && this.isEquals(i.getCotacaoCompra().getEmpresa().getEmpresaDados().getLancarCtoCustoEntrada(), EnumConstantsMentorSimNao.SIM.getValue())) {
                this.valid(this.code("V.ERP.1066.022"), i.getCentroCustoReq());
            }
            this.valid(this.code("V.ERP.1066.023"), i.getNaturezaRequisicao());
        }
        if (ToolMethods.isNotNull((Object)i.getCotacaoCompra().getEmpresa()).booleanValue() && ToolMethods.isNotNull((Object)this.getSharedObjects()).booleanValue() && ToolMethods.isNotNull((Object)(opcoesGerenciais = this.getSharedObjects().getOpcoesGerenciais(i.getCotacaoCompra().getEmpresa()))).booleanValue() && this.isEquals(opcoesGerenciais.getObrigarInfCCCotCompraOrdCompra(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.valid(this.code("V.ERP.1066.022"), i.getCentroCustoReq());
        }
        if (this.isEquals(i.getNaoGerarOC(), EnumConstantsMentorSimNao.SIM.getValue()) && !ToolMethods.isStrWithData((String)i.getJustificativa())) {
            this.addError(this.code("V.ERP.1066.024"), i.getJustificativa());
        }
        if (ToolMethods.isWithData((Collection)i.getNecessidadesCompra())) {
            Double quantidadeTotal = 0.0;
            for (NecessidadeCompra necessidadeCompra : i.getNecessidadesCompra()) {
                quantidadeTotal = quantidadeTotal + necessidadeCompra.getQuantidadeNecessidade();
            }
            if (!this.isEquals(quantidadeTotal, i.getQuantidade())) {
                if (ToolMethods.isNotNull((Object)i.getIdentificador()).booleanValue()) {
                    this.addError(this.code("V.ERP.1066.025", i.getIdentificador()), i.getQuantidade());
                } else {
                    this.addError(this.code("V.ERP.1066.025"), i.getQuantidade());
                }
            }
        }
    }

    public ValidImpl isValidBeforePesquisaFornecedoresSug(WebDTOInputObject<DTOCotacaoCompra.DTOItemCotacaoCompra> item) {
        ValidImpl container = new ValidImpl();
        if (item == null || item.getInput() == null) {
            container.addError(new ValidMessages.Code("E.ERP.1066.005"), item);
            return container;
        }
        if (((DTOCotacaoCompra.DTOItemCotacaoCompra)item.getInput()).getGradeCorIdentificador() == null) {
            container.addError(new ValidMessages.Code("E.ERP.1066.006"), item);
        }
        return container;
    }

    public ValidImpl isValidBeforeCalculoItens(WebDTOInputObject<List<DTOCotacaoCompra.DTOItemCotacaoCompra>> itens) {
        ValidImpl container = new ValidImpl();
        if (itens == null || itens.getInput() == null || ((List)itens.getInput()).isEmpty()) {
            container.addError(new ValidMessages.Code("E.ERP.1066.007"), itens);
            return container;
        }
        return container;
    }

    public ValidImpl isValidBeforeCalculoItem(WebDTOInputObject<DTOCotacaoCompra.DTOItemCotacaoCompra> itens) {
        ValidImpl container = new ValidImpl();
        if (itens == null || itens.getInput() == null) {
            container.addError(new ValidMessages.Code("E.ERP.1066.007"), itens);
            return container;
        }
        return container;
    }

    public ValidImpl isValidBeforeCalculoItemFornecedor(WebDTOInputObject<DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra> item) {
        ValidImpl container = new ValidImpl();
        if (item == null || item.getInput() == null) {
            container.addError(new ValidMessages.Code("E.ERP.1066.007"), item);
            return container;
        }
        if (((DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra)item.getInput()).getModeloFiscal() == null) {
            container.addError(new ValidMessages.Code("E.ERP.1066.009"), ((DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra)item.getInput()).getModeloFiscal());
            return container;
        }
        if (((DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra)item.getInput()).getValorUnitario() == null || ((DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra)item.getInput()).getValorUnitario() <= 0.0) {
            container.addError(new ValidMessages.Code("E.ERP.1066.010"), ((DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra)item.getInput()).getValorUnitario());
            return container;
        }
        return container;
    }

    public ValidImpl isValidBeforeGenerateOrdensCompra(CotacaoCompra vo, OpcoesCompraSuprimentos opcoesCompraSuprimentos) {
        ValidImpl container = new ValidImpl();
        container.valid(new ValidMessages.Code("V.ERP.0804.001"), opcoesCompraSuprimentos.getNaturezaOperacao());
        container.valid(new ValidMessages.Code("V.ERP.1066.010"), vo.getSituacaoCotacaoCompra());
        if (vo.getSituacaoCotacaoCompra() != null) {
            container.validAffirmative(new ValidMessages.Code("V.ERP.1066.010"), vo.getSituacaoCotacaoCompra().getLiberarGeracaoOC());
        }
        Short nrMinimoCotacoes = this.getNrMinimoCotacoes(opcoesCompraSuprimentos);
        this.isValidFornecedorItem(vo.getItensCotacaoCompra(), nrMinimoCotacoes, container);
        this.isValidBeforeGenerateOrdemCompraFromCotacaoCompra(vo, nrMinimoCotacoes, container);
        return container;
    }

    private void isValidFornecedorItem(List<ItemCotacaoCompra> itens, Short nrMinimoCotacoes, ValidImpl container) {
        for (ItemCotacaoCompra vo : itens) {
            if (!this.isAffirmative(vo.getNaoGerarOC())) {
                if (vo.getFornecedoresItemCotacaoCompra().size() < nrMinimoCotacoes) {
                    for (FornecedorItemCotacaoCompra fornecedor : vo.getFornecedoresItemCotacaoCompra()) {
                        if (!this.isAffirmative(fornecedor.getAquisicaoPreferencial()) || !this.isAffirmative(fornecedor.getValidado())) continue;
                        return;
                    }
                    container.addError(new ValidMessages.Code("E.ERP.1066.022", nrMinimoCotacoes.toString()), nrMinimoCotacoes);
                } else {
                    Integer nrValidados = 0;
                    Boolean valido = false;
                    for (FornecedorItemCotacaoCompra fornecedor : vo.getFornecedoresItemCotacaoCompra()) {
                        if (this.isAffirmative(fornecedor.getAquisicaoPreferencial())) {
                            valido = true;
                            break;
                        }
                        if (!this.isAffirmative(fornecedor.getValidado())) continue;
                        Integer n = nrValidados;
                        nrValidados = nrValidados + 1;
                    }
                    if (nrValidados < nrMinimoCotacoes && !valido.booleanValue()) {
                        container.addError(new ValidMessages.Code("E.ERP.1066.023", nrMinimoCotacoes.toString()), nrMinimoCotacoes);
                    }
                }
            }
            Double quantidadeTotal = 0.0;
            for (NecessidadeCompra necessidadeCompra : vo.getNecessidadesCompra()) {
                quantidadeTotal = quantidadeTotal + necessidadeCompra.getQuantidadeNecessidade();
            }
            if (this.isEquals(quantidadeTotal, vo.getQuantidade())) continue;
            this.addError(this.code("V.ERP.0065.031", "vo.getQuantidade()"), vo.getQuantidade());
        }
    }

    private void isValidBeforeGenerateOrdemCompraFromCotacaoCompra(CotacaoCompra vo, Short nrMinimoCotacoem, ValidImpl container) {
        Boolean todosItensNaoGerarOC = true;
        for (ItemCotacaoCompra item : vo.getItensCotacaoCompra()) {
            if (this.isAffirmative(item.getNaoGerarOC())) continue;
            this.isValidBeforeGenerateOrdemCompraFromItemCotacaoCompra(item, nrMinimoCotacoem, container);
            todosItensNaoGerarOC = false;
        }
        if (todosItensNaoGerarOC.booleanValue()) {
            container.addError(new ValidMessages.Code("E.ERP.1066.030"), vo);
        }
    }

    private void isValidBeforeGenerateOrdemCompraFromItemCotacaoCompra(ItemCotacaoCompra item, Short nrMinimoCotacoes, ValidImpl container) {
        Integer fornecedorContabilizado = 0;
        Boolean foundAquisicaoPreferencial = false;
        Boolean foundSelecionado = false;
        for (FornecedorItemCotacaoCompra fornecedor : item.getFornecedoresItemCotacaoCompra()) {
            if (!TMethods.isNull((Object)fornecedor.getPrazoEntrega()).booleanValue() && !TMethods.isNull((Object)fornecedor.getValorUnitario()).booleanValue() && fornecedor.getValorUnitario() > 0.0 && !TMethods.isNull((Object)fornecedor.getTipoFrete()).booleanValue()) {
                Integer n = fornecedorContabilizado;
                fornecedorContabilizado = fornecedorContabilizado + 1;
            }
            if ((TMethods.isNull((Object)fornecedor.getAquisicaoPreferencial()).booleanValue() || !TMethods.isAffirmative((Number)fornecedor.getAquisicaoPreferencial())) && (TMethods.isNull((Object)fornecedor.getSelecionado()).booleanValue() || !TMethods.isAffirmative((Number)fornecedor.getSelecionado()))) continue;
            if (!TMethods.isNull((Object)fornecedor.getAquisicaoPreferencial()).booleanValue() && TMethods.isAffirmative((Number)fornecedor.getAquisicaoPreferencial())) {
                foundAquisicaoPreferencial = true;
            }
            foundSelecionado = true;
            container.valid(new ValidMessages.Code("V.ERP.1066.011", fornecedor.getUnidadeFaturamentoFornecedor().toString(), item.getGradeCor().getProdutoGrade().getProduto().getIdentificador(), item.getGradeCor().getProdutoGrade().getProduto().getNome()), fornecedor.getModeloFiscal());
            container.valid(new ValidMessages.Code("V.ERP.1066.012", fornecedor.getUnidadeFaturamentoFornecedor().toString(), item.getGradeCor().getProdutoGrade().getProduto().getIdentificador(), item.getGradeCor().getProdutoGrade().getProduto().getNome()), fornecedor.getCondicoesPagamento());
            container.valid(new ValidMessages.Code("V.ERP.1066.013", fornecedor.getUnidadeFaturamentoFornecedor().toString(), item.getGradeCor().getProdutoGrade().getProduto().getIdentificador(), item.getGradeCor().getProdutoGrade().getProduto().getNome()), fornecedor.getTipoFrete());
            container.valid(new ValidMessages.Code("V.ERP.1066.014", fornecedor.getUnidadeFaturamentoFornecedor().toString(), item.getGradeCor().getProdutoGrade().getProduto().getIdentificador(), item.getGradeCor().getProdutoGrade().getProduto().getNome()), fornecedor.getPrazoEntrega());
            container.validGreather0(new ValidMessages.Code("V.ERP.1066.015", fornecedor.getUnidadeFaturamentoFornecedor().toString(), item.getGradeCor().getProdutoGrade().getProduto().getIdentificador(), item.getGradeCor().getProdutoGrade().getProduto().getNome()), fornecedor.getValorUnitario());
        }
        if (!foundSelecionado.booleanValue() || !foundAquisicaoPreferencial.booleanValue() && fornecedorContabilizado < nrMinimoCotacoes) {
            container.addError(new ValidMessages.Code("E.ERP.1066.029", item.getCotacaoCompra().getIdentificador(), nrMinimoCotacoes.toString(), item.getGradeCor().getProdutoGrade().getProduto().getIdentificador(), item.getGradeCor().getProdutoGrade().getProduto().getNome()), item);
        }
    }

    private Short getNrMinimoCotacoes(OpcoesCompraSuprimentos opcoesCompraSuprimentos) {
        Short nrMinimoCotacoes = opcoesCompraSuprimentos.getNumeroMinimoCotacoes();
        if (TMethods.isNull((Object)nrMinimoCotacoes).booleanValue()) {
            return (short)3;
        }
        return opcoesCompraSuprimentos.getNumeroMinimoCotacoes();
    }

    @Override
    public String getSimpleName() {
        return "Cota\u00e7\u00e3o de Compra";
    }
}

