/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.diagnosticoosativo;

import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivo;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoItens;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServProc;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServico;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Iterator;
import org.springframework.stereotype.Component;

@Component
public class ValidDiagnosticoOSAtivo
extends ValidGenericEntitiesImpl<DiagnosticoOSAtivo> {
    @Override
    protected void isValid(DiagnosticoOSAtivo vo) {
        this.valid(this.code("V.ERP.1540.001", "observacao"), vo.getObservacao());
        this.valid(this.code("V.ERP.1540.002", "ordemServico"), vo.getOrdemServico());
        if (vo.getOrdemServico() != null && vo.getOrdemServico().getFechamentoOrdemServico() != null && this.isAffirmative(vo.getOrdemServico().getFechamentoOrdemServico().getOsFechada())) {
            this.newMessageItem(this.code("V.ERP.1540.003"), vo.getOrdemServico().getFechamentoOrdemServico());
        }
        this.valid(this.code("V.ERP.1540.004", "responsavel"), vo.getResponsavel());
        this.valid(this.code("V.ERP.1540.005", "servicos"), (Object)vo.getServicos());
        if (this.isAffirmative(vo.getGerarPedAlmoxarifado())) {
            this.valid(this.code("V.ERP.1540.006", "dataNecessidade"), vo.getDataNecessidade());
            for (DiagnosticoOSAtivoServico servico : vo.getServicos()) {
                for (DiagnosticoOSAtivoServProc proc : servico.getProcedimentos()) {
                    Iterator iterator = proc.getItens().iterator();
                    if (!iterator.hasNext()) continue;
                    DiagnosticoOSAtivoItens iten = (DiagnosticoOSAtivoItens)iterator.next();
                    this.validGreather0(this.code("V.ERP.1540.007", "quantidade"), iten.getQuantidade());
                }
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "Diagnostico OS Ativo";
    }
}

