/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.equipamento;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.TipoPontoControleAtivo;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidEquipamento
extends ValidGenericEntitiesImpl<Equipamento> {
    @Override
    protected void isValid(Equipamento vo) {
        if (this.valid(this.code("V.ERP.0121.001", "codigo"), vo.getCodigo())) {
            this.validarCodigoAtivo(vo);
        }
        this.valid(this.code("V.ERP.0121.002", "tipoEquipamento"), vo.getTipoEquipamento());
        this.valid(this.code("V.ERP.0121.003", "nome"), vo.getNome());
        this.valid(this.code("V.ERP.0121.004", "empresaProprietaria"), vo.getEmpresaProprietaria());
        this.valid(this.code("V.ERP.0121.008", "empresa"), vo.getEmpresa());
        if (this.valid(this.code("V.ERP.0121.005", "tipoPontoControleAtivo"), (Object)vo.getTipoPontoControleAtivo())) {
            for (TipoPontoControleAtivo tp : vo.getTipoPontoControleAtivo()) {
                this.valid(this.code("V.ERP.0121.006", "tipoPontoControle"), tp.getTipoPontoControle());
            }
        }
        if (vo.getCentroCusto() != null && !this.isEqualsNumber(vo.getCentroCusto().getMarca(), EnumConstSinteticoAnalitico.ANALITICO.getValueInt())) {
            this.addError(this.code("V.ERP.0097.004", "centroCusto"), vo.getCentroCusto());
        }
        if (vo.getContaContabil() != null && !this.isEqualsNumber(vo.getContaContabil().getMarca(), EnumConstSinteticoAnalitico.ANALITICO.getValueInt())) {
            this.addError(this.code("V.ERP.0160.007", "contaContabil"), vo.getContaContabil());
        }
        if (vo.getContaGerencial() != null && !this.isEqualsNumber(vo.getContaGerencial().getMarca(), EnumConstSinteticoAnalitico.ANALITICO.getValueInt())) {
            this.addError(this.code("V.ERP.0164.004", "contaGerencial"), vo.getContaGerencial());
        }
    }

    public void validarCodigoAtivo(Equipamento vo) {
        if (this.getSharedObjects() == null) {
            return;
        }
        String codigo = vo.getCodigo();
        Empresa empresa = vo.getEmpresa();
        OpcoesManutencEquip opManu = this.getSharedObjects().getOpcoesManutencaoEquip(empresa);
        if (opManu == null || !TMethods.isStrWithData((String)opManu.getMascaraCodigoAtivo())) {
            return;
        }
        String mascara = opManu.getMascaraCodigoAtivo();
        Object validandoMascara = "--------Validando C\u00f3digo--------";
        boolean codValido = true;
        block6: for (int i = 0; i < mascara.length(); ++i) {
            switch (mascara.charAt(i)) {
                case 'L': {
                    validandoMascara = (String)validandoMascara + "\nL:" + codigo.charAt(i);
                    if (codigo.charAt(i) != ' ') continue block6;
                    System.out.println((String)validandoMascara);
                    codValido = false;
                    break block6;
                }
                case 'l': {
                    validandoMascara = (String)validandoMascara + "\nl:" + codigo.charAt(i);
                    if (Character.isLetter(codigo.charAt(i)) || Character.isWhitespace(codigo.charAt(i))) continue block6;
                    System.out.println((String)validandoMascara);
                    codValido = false;
                    break block6;
                }
                case 'N': {
                    validandoMascara = (String)validandoMascara + "\nN:" + codigo.charAt(i);
                    if (codigo.charAt(i) != ' ') continue block6;
                    System.out.println((String)validandoMascara);
                    codValido = false;
                    break block6;
                }
                case 'n': {
                    validandoMascara = (String)validandoMascara + "\nn:" + codigo.charAt(i);
                    if (Character.isDigit(codigo.charAt(i)) || Character.isWhitespace(codigo.charAt(i))) continue block6;
                    System.out.println((String)validandoMascara);
                    codValido = false;
                    break block6;
                }
                default: {
                    validandoMascara = (String)validandoMascara + "\n" + mascara.charAt(i) + ":" + codigo.charAt(i);
                }
            }
        }
        if (!codValido) {
            this.addError(this.code("V.ERP.0121.001", "codigo", codigo, mascara), codigo);
        }
        System.out.println((String)validandoMascara);
    }

    @Override
    public String getSimpleName() {
        return "Equipamento";
    }
}

