/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.esocloteeventos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocLoteEventos;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidEsocLoteEventos
extends ValidGenericEntitiesImpl<EsocLoteEventos> {
    @Override
    protected void isValid(EsocLoteEventos vo) {
        this.valid(this.code("V.ERP.0588.001"), (Object)vo.getEventos());
        if (ToolMethods.isWithData((Collection)vo.getEventos())) {
            this.validMax(this.code("V.ERP.0588.002"), vo.getEventos().size(), 50);
            if (this.validEsocEventos(vo.getEventos())) {
                this.addError(this.code("V.ERP.0588.003"), vo);
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private boolean validEsocEventos(List<EsocEvento> eventos) {
        for (EsocEvento evento : eventos) {
            if (!this.isEquals(evento.getPreEvento().getDesativarEnvio(), EnumConstantsMentorSimNao.SIM.getValue()) || ToolMethods.isStrWithData((String)evento.getPreEvento().getMotivoDesativarEnvio())) continue;
            return true;
        }
        return false;
    }
}

