/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.esocprocessotrabalhista;

import com.touchcomp.basementor.constants.enums.processotrabalhista.EnumConstOrigemProcessoTrab;
import com.touchcomp.basementor.constants.enums.processotrabalhista.EnumConstTipoCcp;
import com.touchcomp.basementor.constants.enums.tipocontrato.EnumConstTipoContrato;
import com.touchcomp.basementor.model.vo.BaseCalculoContribPrevidenciaria;
import com.touchcomp.basementor.model.vo.EsocProcessoTrabalhista;
import com.touchcomp.basementor.model.vo.InformacoesFGTS;
import com.touchcomp.basementor.model.vo.Remuneracao;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class ValidEsocProcessoTrabalhista
extends ValidGenericEntitiesImpl<EsocProcessoTrabalhista> {
    @Override
    public String getSimpleName() {
        return "S-2500 - Processo Trabalhista";
    }

    @Override
    protected void isValid(EsocProcessoTrabalhista entity) {
        this.valid(this.code("V.ERP.1983.001", "recisao"), entity.getRecisao());
        this.valid(this.code("V.ERP.1983.002", "competenciaInicial"), entity.getCompetenciaInicial());
        this.valid(this.code("V.ERP.1983.003", "competenciaFinal"), entity.getCompetenciaFinal());
        if (TMethods.isEquals((Object)entity.getOrigem(), (Object)EnumConstOrigemProcessoTrab.PROCESSO.getEnumId())) {
            this.validLenght(this.code("V.ERP.1983.004", "nrProcTrab", 20), entity.getNrProcTrab(), 20, new Object[0]);
        } else {
            this.validLenght(this.code("V.ERP.1983.004", "nrProcTrab", 15), entity.getNrProcTrab(), 15, new Object[0]);
        }
        if (TMethods.isEquals((Object)entity.getTpCCP(), (Object)EnumConstTipoCcp.SINDICATO.getEnumId()) || TMethods.isEquals((Object)entity.getTpCCP(), (Object)EnumConstTipoCcp.NINTER.getEnumId())) {
            this.valid(this.code("V.ERP.1983.006", "cnpjccp"), entity.getCnpjCCP());
        }
        if (entity.getRecisao() != null) {
            if (entity.getRemuneracoes() != null) {
                for (Remuneracao rem : entity.getRemuneracoes()) {
                    this.validAfterEqual(this.code("V.ERP.1983.007", "dtRemun"), rem.getDtRemun(), entity.getRecisao().getColaborador().getDataAdmissao(), new Object[0]);
                    this.validBeforeEqual(this.code("V.ERP.1983.007", "dtRemun"), rem.getDtRemun(), entity.getRecisao().getColaborador().getDataDemissao(), new Object[0]);
                }
            }
            if (entity.getCompetenciaInicial() != null) {
                Date compIni = entity.getCompetenciaInicial();
                if (entity.getTipoContrato() != null) {
                    Date dataAdmissao = entity.getRecisao().getColaborador().getDataAdmissao();
                    if (TMethods.isEquals((Object)entity.getTipoContrato().getCodigo(), (Object)EnumConstTipoContrato.VINC_FORM_SEM_ALT_DATA_ADM_DES.getEnumId()) || TMethods.isEquals((Object)entity.getTipoContrato().getCodigo(), (Object)EnumConstTipoContrato.VINC_FORM_COM_INC_ALT_DATA_DES.getEnumId()) || TMethods.isEquals((Object)entity.getTipoContrato().getCodigo(), (Object)EnumConstTipoContrato.VINCULO_FORMALIZADO_PER_ANT_ESOCIAL.getEnumId()) || TMethods.isEquals((Object)entity.getTipoContrato().getCodigo(), (Object)EnumConstTipoContrato.RESPONSABILIDADE_INDIRETA.getEnumId()) || TMethods.isEquals((Object)entity.getTipoContrato().getCodigo(), (Object)EnumConstTipoContrato.CONTRATO_UNIFICADO.getEnumId())) {
                        this.validAfterEqualMonthYear(this.code("V.ERP.1983.008", "competenciaInicial"), dataAdmissao, compIni, new Object[0]);
                    }
                    if (TMethods.isEquals((Object)entity.getTipoContrato().getCodigo(), (Object)EnumConstTipoContrato.VINC_FORM_COM_ALT_DATA_ADM.getEnumId()) || TMethods.isEquals((Object)entity.getTipoContrato().getCodigo(), (Object)EnumConstTipoContrato.VINC_FORM_COM_ALT_DATA_ADM_INC_DES.getEnumId()) || TMethods.isEquals((Object)entity.getTipoContrato().getCodigo(), (Object)EnumConstTipoContrato.RECONHECIMENTO_VINCULO.getEnumId()) || TMethods.isEquals((Object)entity.getTipoContrato().getCodigo(), (Object)EnumConstTipoContrato.SEM_VINCULO_EMPREGATICIO.getEnumId())) {
                        this.validEqualMonthYear(this.code("V.ERP.1983.009", "competenciaInicial"), dataAdmissao, compIni, new Object[0]);
                    }
                }
                if (entity.getCompetenciaFinal() != null) {
                    Date compFim = entity.getCompetenciaFinal();
                    this.validAfterEqualMonthYear(this.code("V.ERP.1983.010", "competenciaFinal"), compIni, compFim, new Object[0]);
                    if (entity.getDtSent() != null) {
                        this.validBeforeEqual(this.code("V.ERP.1983.005", "dtSent"), entity.getDtSent(), new Date(), new Object[0]);
                        this.validBeforeMonthYear(this.code("V.ERP.1983.011", "competenciaFinal"), compFim, entity.getDtSent(), new Object[0]);
                    } else if (entity.getDtCCP() != null) {
                        this.validBeforeMonthYear(this.code("V.ERP.1983.011", "competenciaFinal"), compFim, entity.getDtCCP(), new Object[0]);
                    } else {
                        this.addError(this.code("V.ERP.1983.012", "dtSent"), entity.getDtSent());
                    }
                    if (entity.getBaseCalculoContribPrevidenciarias() != null) {
                        for (BaseCalculoContribPrevidenciaria bc : entity.getBaseCalculoContribPrevidenciarias()) {
                            this.valid(this.code("V.ERP.1983.013", "perRef"), bc.getPerRef());
                            this.validGreather0(this.code("V.ERP.1983.014", "vrBcCpMensal"), bc.getVrBcCpMensal());
                            this.validGreather0(this.code("V.ERP.1983.015", "vrBcCp13"), bc.getVrBcCp13());
                            if (bc.getPerRef() == null) continue;
                            this.validBetween(this.code("V.ERP.1983.013", "periodo"), compIni, compFim, bc.getPerRef(), new Object[0]);
                        }
                    }
                }
            }
        }
        if (entity.getInformacoesFGTS() != null) {
            for (InformacoesFGTS inf : entity.getInformacoesFGTS()) {
                this.validGreather0(this.code("V.ERP.1983.016", "vrBcFGTSProcTrab"), inf.getVrBcFGTSProcTrab());
                this.validGreather0(this.code("V.ERP.1983.017", "vrBcFGTSSefip"), inf.getVrBcFGTSSefip());
                this.validGreather0(this.code("V.ERP.1983.018", "vrBcFGTSDecAnt"), inf.getVrBcFGTSDecAnt());
            }
        }
    }
}

