/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.evento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Evento;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidEvento
extends ValidGenericEntitiesImpl<Evento> {
    @Override
    protected void isValid(Evento vo) {
        this.valid(this.code("V.ERP.1662.001", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.1662.002", "codigo"), vo.getCodigo());
        this.valid(this.code("V.ERP.1662.003", "chave"), vo.getChave());
        this.valid(this.code("V.ERP.1662.004", "tipoEvento"), vo.getTipoEvento());
        this.valid(this.code("V.ERP.1662.005", "tipoCalculoEvento"), (Object)vo.getTipoCalculoEvento());
        if (this.isEquals(vo.getInformarCodigoEsocial(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.valid(this.code("V.ERP.1662.015", "ideTabelaRubrica"), vo.getIdeTabelaRubrica());
            this.valid(this.code("V.ERP.1662.016", "codigoEsocial"), vo.getCodigoEsocial());
        }
        if (ToolMethods.isWithData((Collection)vo.getTipoCalculoEvento())) {
            for (TipoCalculoEvento t : vo.getTipoCalculoEvento()) {
                this.valid(this.code("V.ERP.1662.006", "mediaFerias"), t.getMediaFerias());
                this.valid(this.code("V.ERP.1662.007", "media13Salario"), t.getMedia13Salario());
                this.valid(this.code("V.ERP.1662.008", "mediaAvisoPrevio"), t.getMediaAvisoPrevio());
                this.valid(this.code("V.ERP.1662.009", "esocRubricaPrevidencia"), t.getEsocRubricaPrevidencia());
                this.valid(this.code("V.ERP.1662.010", "esocRubricaIrrf"), t.getEsocRubricaIrrf());
                this.valid(this.code("V.ERP.1662.011", "esocRubricaFgts"), t.getEsocRubricaFgts());
                this.valid(this.code("V.ERP.1662.012", "esocRubricaSindical"), t.getEsocRubricaSindical());
                this.valid(this.code("V.ERP.1662.013", "esocRubricasFolhaPagamento"), t.getEsocRubricasFolhaPagamento());
                this.valid(this.code("V.ERP.1662.014", "dataInicio"), t.getDataInicio());
                if (this.isEquals(t.getCompeDRSHoraExtra(), EnumConstantsMentorSimNao.SIM.getValue())) {
                    this.valid(this.code("V.ERP.1662.017", "tipoCalculoDSRHoraExtra"), t.getTipoCalculoDSRHoraExtra());
                }
                if (this.isEquals(t.getCompoeDSRAddNoturno(), EnumConstantsMentorSimNao.SIM.getValue())) {
                    this.valid(this.code("V.ERP.1662.018", "tipoCalculoDSRAddNoturno"), t.getTipoCalculoDSRAddNoturno());
                }
                if (!this.isEquals(t.getCompoeDSRComissao(), EnumConstantsMentorSimNao.SIM.getValue())) continue;
                this.valid(this.code("V.ERP.1662.019", "tipoCalculoDSRComissao"), t.getTipoCalculoDSRComissao());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }
}

