/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.eventoosprodsobenc;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ColaboradorEvtOsProdSobEnc;
import com.touchcomp.basementor.model.vo.EventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.EvtOSSobEncomendaEquip;
import com.touchcomp.basementor.model.vo.FichaTecEvtOSSobEncomenda;
import com.touchcomp.basementor.model.vo.ItemEventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.ItemModFichaTecVlrPad;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.ValorFichaTecEvtOSProdSobEnc;
import com.touchcomp.basementorvalidator.dto.ValidGenericDTOImpl;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.modelofichatecnica.InterfaceFichaTecnica;
import com.touchcomp.basementorvalidator.entities.impl.modelofichatecnica.InterfaceFichaTecnicaValor;
import com.touchcomp.basementorvalidator.entities.impl.modelofichatecnica.ValidFichaTecnica;
import com.touchcomp.basementorvalidator.entities.impl.requisicao.ValidRequisicao;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidEventoOsProdSobEnc
extends ValidGenericEntitiesImpl<EventoOsProdSobEnc> {
    @Autowired
    ValidFichaTecnica validFichaTecnica;
    @Autowired
    ValidRequisicao validRequisicao;

    @Override
    protected void isValid(EventoOsProdSobEnc vo) {
        this.valid(this.code("V.ERP.0427.001", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.0427.004", "tipoEvento"), vo.getTipoEvento());
        this.valid(this.code("V.ERP.0427.008", "tipoApontEvento"), vo.getTipoApontEvento());
        this.valid(this.code("V.ERP.0427.002", "dataAbertura"), vo.getDataAbertura());
        if (vo.getDataFechamento() != null) {
            this.validBeforeEqual(this.code("V.ERP.0427.011", "dataAbertura"), vo.getDataAbertura(), vo.getDataFechamento(), new Object[0]);
        }
        this.valid(this.code("V.ERP.0427.006", "horaEvento"), vo.getHoraEvento());
        this.valid(this.code("V.ERP.0427.007", "subdivisaoOSProdSobEnc"), vo.getSubdivisaoOSProdSobEnc());
        this.valid(this.code("V.ERP.0427.005", "faseProdutiva"), vo.getFaseProdutiva());
        this.validColaboradores(vo);
        this.validEquipamentos(vo);
        this.validRequisicoes(vo);
        this.validFichasTecnicas(vo);
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validColaboradores(EventoOsProdSobEnc vo) {
        if (this.getSharedObjects() == null) {
            return;
        }
        OpcoesPCP opcoes = this.getSharedObjects().getOpcoesPCP(vo.getEmpresa());
        if (opcoes == null || !this.isAffirmative(opcoes.getObrigarInformarColEvtProd())) {
            return;
        }
        if (this.validNotEmpty(this.code("V.ERP.0427.010", "colaboradoresEvtProd"), vo.getColaboradoresEvtProd())) {
            for (ColaboradorEvtOsProdSobEnc colab : vo.getColaboradoresEvtProd()) {
                this.valid(this.code("V.ERP.0427.010", "colaborador"), colab.getColaborador());
            }
        }
    }

    private void validEquipamentos(EventoOsProdSobEnc vo) {
        if (this.valid(this.code("V.ERP.0427.009", "equipamentos"), (Object)vo.getEquipamentos())) {
            for (EvtOSSobEncomendaEquip colab : vo.getEquipamentos()) {
                this.valid(this.code("V.ERP.0427.009", "equipamento"), colab.getFaseProdutivaEquip());
            }
        }
    }

    private void validRequisicoes(EventoOsProdSobEnc vo) {
        if (vo.getItemEventoOsProdSobEnc() != null) {
            for (ItemEventoOsProdSobEnc item : vo.getItemEventoOsProdSobEnc()) {
                this.valid((ValidGenericEntitiesImpl)this.validRequisicao, (InterfaceVO)item.getRequisicao());
            }
        }
    }

    private void validFichasTecnicas(EventoOsProdSobEnc vo) {
        if (vo.getFichasTecnicas() == null) {
            return;
        }
        for (final FichaTecEvtOSSobEncomenda ficha : vo.getFichasTecnicas()) {
            InterfaceFichaTecnica f = new InterfaceFichaTecnica(){

                @Override
                public ModeloFichaTecnica getModeloFichaTecnica() {
                    return ficha.getModeloFichaTecnica();
                }

                @Override
                public List<InterfaceFichaTecnicaValor> getItens() {
                    LinkedList<InterfaceFichaTecnicaValor> r = new LinkedList<InterfaceFichaTecnicaValor>();
                    for (final ValorFichaTecEvtOSProdSobEnc valor : ficha.getValoresFichaTecEvtOSProd()) {
                        r.add(new InterfaceFichaTecnicaValor(){

                            @Override
                            public String getDescricao() {
                                return valor.getChave();
                            }

                            @Override
                            public String getValor() {
                                return valor.getValor();
                            }

                            @Override
                            public ItemModFichaTecVlrPad getValorInfPadrao() {
                                return valor.getVlrPadraoSelecionado();
                            }

                            @Override
                            public Short getValorObrigatorio() {
                                return valor.getValorObrigatorio();
                            }
                        });
                    }
                    return r;
                }
            };
            this.valid((ValidGenericDTOImpl)this.validFichaTecnica, f);
        }
    }
}

