/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.grupocompensacao;

import com.touchcomp.basementor.constants.enums.tipocompesacaocheque.EnumConstTipoCompesacaoCheque;
import com.touchcomp.basementor.model.vo.CompensacaoCheque;
import com.touchcomp.basementor.model.vo.GrupoCompensacao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class ValidGrupoCompensacao
extends ValidGenericEntitiesImpl<GrupoCompensacao> {
    @Override
    public void isValid(GrupoCompensacao vo) {
        boolean existTipoCompPrescrito = false;
        this.validNotEmpty(this.code("V.ERP.0326.001", "compensacaoCheques"), vo.getCompensacaoCheques());
        if (ToolMethods.isNotNull((Object)vo.getCompensacaoCheques()).booleanValue()) {
            for (CompensacaoCheque comp : vo.getCompensacaoCheques()) {
                this.valid(this.code("V.ERP.0326.002", comp.getCheque().getNumero()), comp.getDataCompensacao());
                this.validAfter(this.code("V.ERP.0326.003", comp.getCheque().getNumero()), comp.getDataCompensacao(), new Date(), new Object[0]);
                this.validBefore(this.code("V.ERP.0326.004", comp.getCheque().getNumero()), comp.getCheque().getDataEmissao(), comp.getDataCompensacao(), new Object[0]);
                this.valid(this.code("V.ERP.0326.005", comp.getCheque().getNumero(), comp.getCheque().getFavorecido()), comp.getCheque().getConta().getPcChequeTransito());
                this.valid(this.code("V.ERP.0326.006", comp.getCheque().getNumero()), comp.getTipoCompensacao());
                if (!this.isEquals(comp.getTipoCompensacao(), EnumConstTipoCompesacaoCheque.PRESCRITO.getValue())) continue;
                existTipoCompPrescrito = true;
            }
        }
        if (existTipoCompPrescrito) {
            this.valid(this.code("V.ERP.0326.007", "modeloLancBancario"), vo.getModeloLancBancario());
            this.valid(this.code("V.ERP.0326.008", "historico"), vo.getHistorico());
            this.valid(this.code("V.ERP.0326.009", "contaValor"), vo.getContaValor());
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }
}

