/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.horariotrabalho;

import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.DiaHorarioTrabalho;
import com.touchcomp.basementor.model.vo.EsocCadastroHorario;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.HoraExtraHorTrab;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.PeriodoHorTrab;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidHorarioTrabalho
extends ValidGenericEntitiesImpl<HorarioTrabalho> {
    @Override
    protected void isValid(HorarioTrabalho vo) {
        this.valid(this.code("V.ERP.1665.001", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.1665.002", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.1665.003", "descricaoHorario"), vo.getDescricaoHorario());
        this.valid(this.code("V.ERP.1665.004", "turnoDeTrabalho"), vo.getTurnoDeTrabalho());
        this.validarHorariosInformados(vo.getDiaHorarioTrabalho());
        this.validarHoraExtra(vo.getHorasExtras());
        if (this.isAffirmative(vo.getEsocCadastroHorario().getAtivo())) {
            this.verificarInatividadeHorario(vo.getEsocCadastroHorario());
        }
        this.verificarInformacoesEsocial(vo);
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void verificarInatividadeHorario(EsocCadastroHorario esocCadastroHorario) {
        InfoHorarioTrabalho info;
        if (esocCadastroHorario.getInfoHorario() != null && (info = esocCadastroHorario.getInfoHorario()).getEnviarEsocial().equals((short)1)) {
            for (EsocPreEvento obj : info.getPreEventosEsocial()) {
                if (!this.isEqualsNumber(obj.getEventoProdRestritaProducao(), EnumConstEventoProducao.EVENTO_PRODUCAO.getValue()) || obj.getEsocEvento() == null || !this.isEqualsNumber(obj.getEsocEvento().getStatus(), EnumConstESocialStatus.STATUS_SUCESSO.getValue())) continue;
                this.addError(this.code("V.ERP.1665.005", "diaHorarioTrabalho.horaFinal"), obj.getEsocEvento().getStatus());
            }
        }
    }

    private void validarHoraExtra(List<HoraExtraHorTrab> horaExtra) {
        if (horaExtra == null) {
            return;
        }
        for (HoraExtraHorTrab hora : horaExtra) {
            this.valid(this.code("V.ERP.1665.006", "horasExtras.numeroHoras"), hora.getNumeroHoras());
        }
    }

    private void validarHorariosInformados(List<DiaHorarioTrabalho> diaHorarioTrabalho) {
        if (diaHorarioTrabalho == null) {
            return;
        }
        Iterator<DiaHorarioTrabalho> iterator = diaHorarioTrabalho.iterator();
        while (iterator.hasNext()) {
            DiaHorarioTrabalho o;
            DiaHorarioTrabalho d = o = iterator.next();
            for (int i = 0; i < d.getPeriodosTrabalho().size(); ++i) {
                PeriodoHorTrab p = (PeriodoHorTrab)d.getPeriodosTrabalho().get(i);
                this.valid(this.code("V.ERP.1665.007", "diaHorarioTrabalho.horaInicial"), p.getHoraInicial());
                this.valid(this.code("V.ERP.1665.008", "diaHorarioTrabalho.horaFinal"), p.getHoraFinal());
                if (p.getHoraInicial() >= p.getHoraFinal()) {
                    this.addError(this.code("V.ERP.1665.009", "diaHorarioTrabalho.horaFinal"), p.getHoraFinal());
                }
                for (int j = i + 1; j < d.getPeriodosTrabalho().size(); ++j) {
                    PeriodoHorTrab p2 = (PeriodoHorTrab)d.getPeriodosTrabalho().get(j);
                    if (!(p2.getHoraInicial() <= p.getHoraFinal())) continue;
                    this.addError(this.code("V.ERP.1665.010", "diaHorarioTrabalho.horaFinal", d.getDataHorTrab()), p.getHoraFinal());
                }
            }
        }
    }

    private void verificarInformacoesEsocial(HorarioTrabalho vo) {
        if (vo.getEsocCadastroHorario() == null) {
            return;
        }
        EsocCadastroHorario esoc = vo.getEsocCadastroHorario();
        this.valid(this.code("V.ERP.1665.011", "esocCadastroHorario"), vo.getEsocCadastroHorario());
        this.valid(this.code("V.ERP.1665.012", "tipoJornada"), vo.getTipoJornada());
        if (this.isEquals(esoc.getTipoJornada().getCodigo(), "4") || this.isEquals(esoc.getTipoJornada().getCodigo(), "1") || this.isEquals(esoc.getTipoJornada().getCodigo(), "5") || this.isEquals(esoc.getTipoJornada().getCodigo(), "6")) {
            this.verificarIntervalo(esoc);
        } else if (this.isEquals(esoc.getTipoJornada().getCodigo(), "3")) {
            this.verificarIntervalo(esoc);
        } else if (this.isEquals(esoc.getTipoJornada().getCodigo(), "9")) {
            // empty if block
        }
    }

    private void verificarIntervalo(EsocCadastroHorario esoc) {
        if (esoc.getInfoHorario() == null && esoc.getIntervaloHorarioFixo().equals((short)0)) {
            for (InfoHorarioTrabalho info : esoc.getListaHorario()) {
                if (info.getEnviarEsocial().equals((short)1) && info.getTotalHoras() > 240.0 && info.getTotalIntervalo() == 0.0) {
                    this.addError(this.code("V.ERP.1665.013", "totalHoras", info.getTotalHoras()), info.getTotalHoras());
                }
                if (!info.getEnviarEsocial().equals((short)1) || ToolDate.get((int)11, (Date)info.getFinalIntervalo()) != 0 || ToolDate.get((int)11, (Date)info.getHorarioFinal()) != 0) continue;
                this.addError(this.code("V.ERP.1665.014", "totalHoras", info.getTotalHoras()), info.getTotalHoras());
            }
        }
        for (InfoHorarioTrabalho info : esoc.getListaHorario()) {
            if (!info.getEnviarEsocial().equals((short)1) || ToolDate.get((int)11, (Date)info.getFinalIntervalo()) != 0 || ToolDate.get((int)11, (Date)info.getHorarioFinal()) != 0) continue;
            this.addError(this.code("V.ERP.1665.015", "finalIntervalo", info.getTotalHoras()), info.getFinalIntervalo());
        }
    }
}

