/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.imptransfsaldocontabil;

import com.touchcomp.basementor.constants.enums.imptransfsaldocontabil.ConstEnumImpTransfSaldoContabil;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ImpTransfSaldoContabilItem;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.lotecontabil.ValidLoteContabil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ValidImpTransfSaldoContabilItem
extends ValidGenericEntitiesImpl<ImpTransfSaldoContabilItem> {
    @Autowired
    ValidLoteContabil validLoteContabil;

    @Override
    protected void isValid(ImpTransfSaldoContabilItem vo) {
        if (vo.getImpTransfSaldoContabil() != null && ToolMethods.isEquals((Object)vo.getImpTransfSaldoContabil().getTipoImportacao(), (Object)ConstEnumImpTransfSaldoContabil.IMPORTACAO_LANCAMENTOS_SIMPLES.getValue())) {
            this.valid(this.code("V.ERP.1997.005", "historico"), vo.getHistorico());
            if (vo.getPlanoContaCredito() == null && vo.getPlanoContaDebito() == null) {
                this.addError(this.code("V.ERP.1997.006", "planoContaDebito"), vo.getPlanoContaDebito());
            }
        } else if (vo.getImpTransfSaldoContabil() != null && ToolMethods.isEquals((Object)vo.getImpTransfSaldoContabil().getTipoImportacao(), (Object)ConstEnumImpTransfSaldoContabil.IMPORTACAO_TRANSF_SALDOS_CONTABIL.getValue())) {
            this.valid(this.code("V.ERP.1997.007", "codigoContaAnterior"), vo.getCodigoContaAnterior());
            this.valid(this.code("V.ERP.1997.008", "planoContaAtual"), vo.getPlanoContaAtual());
        }
        this.valid(this.code("V.ERP.1997.009", "dataLancamento"), vo.getDataLancamento());
        this.valid(this.code("V.ERP.1997.010", "valor"), vo.getValor());
        if (vo.getLoteContabil() != null) {
            this.valid((ValidGenericEntitiesImpl)this.validLoteContabil, (InterfaceVO)vo.getLoteContabil());
        }
        if (vo.getPlanoContaDebito() != null && !this.isAffirmative(vo.getPlanoContaDebito().getAtivo())) {
            this.newMessageItem(this.code("V.ERP.1997.011"), "planoContaDebito");
        }
        if (vo.getPlanoContaCredito() != null && !this.isAffirmative(vo.getPlanoContaCredito().getAtivo())) {
            this.newMessageItem(this.code("V.ERP.1997.012"), "planoContaCredito");
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }
}

