/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.infadicionalproduto;

import com.touchcomp.basementor.model.vo.InfAdicionalProdInf;
import com.touchcomp.basementor.model.vo.InfAdicionalProduto;
import com.touchcomp.basementor.model.vo.ItemInfAdicionalProdInf;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.touchvomodel.vo.infadicionalproduto.web.DTOInfAdicionalProduto;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidInfAdicionalProduto
extends ValidGenericEntitiesImpl<InfAdicionalProduto> {
    @Override
    protected void isValid(InfAdicionalProduto vo) {
        this.valid(this.code("V.ERP.0831.001", "produto"), vo.getProduto());
        if (TMethods.isWithData((Collection)vo.getInfAdicionalProdInf())) {
            this.validInfAdicionalProdInf(vo.getInfAdicionalProdInf());
        }
    }

    private void validInfAdicionalProdInf(List<InfAdicionalProdInf> data) {
        for (InfAdicionalProdInf i : data) {
            this.valid(this.code("V.ERP.0831.002", "modeloFicha"), i.getModeloFicha());
            if (!TMethods.isWithData((Collection)i.getItemInfAdicionalProdInf())) continue;
            for (ItemInfAdicionalProdInf it : i.getItemInfAdicionalProdInf()) {
                this.valid(this.code("V.ERP.0831.003", "itemModeloFichaTecnica"), it.getItensModeloFichaTecnica());
                if (!TMethods.isAffirmative((Number)it.getValorObrigatorio())) continue;
                if (TMethods.isNotNull((Object)it.getItensModeloFichaTecnica()).booleanValue()) {
                    this.valid((Object)this.code("V.ERP.0831.004", "valor"), it.getValor(), it.getItensModeloFichaTecnica().getDescricao());
                    continue;
                }
                this.valid((Object)this.code("V.ERP.0831.004", "valor"), it.getValor(), it.getChave());
            }
        }
    }

    public void validImagesInfAdicionalProd(DTOInfAdicionalProduto dto) {
        if (TMethods.isNotNull((Object)dto.getImagemPrincipal()).booleanValue()) {
            this.valid(this.code("V.ERP.0831.005", "imagemPrincipal"), dto.getImagemPrincipal().getHexFotoProduto());
        }
        if (TMethods.isNotNull((Object)dto.getImagensProduto()).booleanValue()) {
            for (DTOInfAdicionalProduto.DTOImagemProduto dtoImg : dto.getImagensProduto()) {
                this.valid(this.code("V.ERP.0831.006", "imagem"), dtoImg.getHexFotoProduto());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "831 - Informa\u00e7\u00e3o Adicional Produto";
    }
}

