/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.integracaorequisicao;

import com.touchcomp.basementor.model.vo.IntegracaoRequisicao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoItem;
import com.touchcomp.basementor.model.vo.LancamentoCentroCusto;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.comunicadoproducao.ValidComunicadoProducaoContabil;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidIntegracaoRequisicao
extends ValidGenericEntitiesImpl<IntegracaoRequisicao> {
    @Autowired
    ValidComunicadoProducaoContabil validComunicado;

    @Override
    protected void isValid(IntegracaoRequisicao entity) {
        this.valid(this.code("V.ERP.0375.001", "dataInicial"), entity.getDataInicial());
        this.valid(this.code("V.ERP.0375.002", "dataFinal"), entity.getDataFinal());
        this.validBefore(this.code("V.ERP.0375.003", "dataFinal"), entity.getDataInicial(), entity.getDataFinal(), new Object[0]);
        this.validNotEmpty(this.code("V.ERP.0375.004", "itens"), entity.getItens());
        this.validaLancamentosSemCentroCusto(entity);
    }

    private void validaLancamentosSemCentroCusto(IntegracaoRequisicao vo) {
        if (vo.getItens() != null) {
            for (IntegracaoRequisicaoItem i : vo.getItens()) {
                if (i.getLancamentosCentroCusto() == null) continue;
                for (LancamentoCentroCusto lanc : i.getLancamentosCentroCusto()) {
                    this.valid(this.code("V.ERP.0375.005", "centroCusto", ToolDate.dateToStr((Date)i.getDataLote())), lanc.getCentroCusto());
                }
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "0940";
    }
}

