/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.lancamento;

import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCTBCentroCustos;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidLancamento
extends ValidGenericEntitiesImpl<Lancamento> {
    @Override
    protected void isValid(Lancamento vo) {
        this.valid(this.code("V.ERP.0378.003", "loteContabil"), vo.getLoteContabil());
        if (vo.getLoteContabil() != null) {
            this.valid(this.code("V.ERP.0378.001", "dataLoteContabil"), vo.getLoteContabil().getDataLote());
        }
        this.validarDadosLancamento(vo);
    }

    public void validarDadosLancamento(Lancamento vo) {
        if (vo.getPlanoContaDeb() == null && vo.getPlanoContaCred() == null) {
            this.valid(this.code("V.ERP.0378.007"), vo.getPlanoContaCred());
        }
        this.validGreather0(this.code("V.ERP.0378.009", "valor"), vo.getValor());
        this.valid(this.code("V.ERP.0378.010", "historico"), vo.getHistorico());
        this.valid(this.code("V.ERP.0378.006", "centroResultadoContFin"), vo.getCentroResultadoContFin());
        this.validarHistorico(vo.getHistorico());
        if (vo.getPlanoContaDeb() != null && !this.isAffirmative(vo.getPlanoContaDeb().getAtivo())) {
            this.newMessageItem(this.code("V.ERP.0378.012"), "planoContaDeb");
        }
        if (vo.getPlanoContaCred() != null && !this.isAffirmative(vo.getPlanoContaCred().getAtivo())) {
            this.newMessageItem(this.code("V.ERP.0378.013"), "planoContaCred");
        }
        this.valid(this.code("V.ERP.0378.016", "dataLancamento"), vo.getDataLancamento());
        this.validarValor(vo);
    }

    private void validarHistorico(String historico) {
        StringToken[] str;
        if (historico != null && (str = ToolString.getReplaceTokensInArray((String)historico)).length > 0) {
            this.newMessageItem(this.code("V.ERP.0378.011"), "historico");
        }
    }

    private void validarValor(Lancamento lancamento) {
        if (TMethods.isWithData((Collection)lancamento.getLancamentosCtbCentroCustos())) {
            Double total = 0.0;
            for (LancamentoCTBCentroCustos i : lancamento.getLancamentosCtbCentroCustos()) {
                total = total + i.getValor();
            }
            if (!this.isEquals(total, lancamento.getValor())) {
                this.newMessageItem(this.code("V.ERP.0378.015"), "historico");
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "Lancamento";
    }
}

