/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.liberacaoestoquenotaterceiros;

import com.touchcomp.basementor.constants.enums.confnfterceiros.EnumConstTipoConfNFTercItens;
import com.touchcomp.basementor.constants.enums.relacionamentopessoa.EnumConstTipoConfNFProduto;
import com.touchcomp.basementor.model.vo.ConferenciaNFTerceiros;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemConfNFTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidConferenciaNFTerceiros
extends ValidGenericEntitiesImpl<ConferenciaNFTerceiros> {
    @Override
    protected void isValid(ConferenciaNFTerceiros vo) {
        this.valid(this.code("V.ERP.0835.001", "usuario"), vo.getUsuario());
        if (this.isAffirmative(vo.getLiberarConferencia())) {
            this.valid(this.code("V.ERP.0835.002", "motivoLiberacao"), vo.getMotivoLiberacao());
        }
        this.valid(this.code("V.ERP.0835.003", "liberacaoNota"), vo.getLiberacaoNota());
        this.valid(this.code("V.ERP.0835.004", "empresa"), vo.getEmpresa());
        this.validNotEmpty(this.code("V.ERP.0835.005", "itemConfNFTerceiros"), vo.getItemConfNFTerceiros());
        if (TMethods.isNotNull((Object)vo.getEmpresa()).booleanValue() && TMethods.isWithData((Collection)vo.getItemConfNFTerceiros())) {
            this.validarItens(vo);
        }
    }

    private void validarItens(ConferenciaNFTerceiros vo) {
        Object erros = "";
        for (ItemConfNFTerceiros i : vo.getItemConfNFTerceiros()) {
            if (!this.conferirProduto(vo, i.getGradeCor()).booleanValue() || this.isEquals(i.getQuantidadeAConferir(), i.getQuantidadeConferida()) || this.isAffirmative(i.getInfManualmente())) continue;
            erros = (String)erros + i.getGradeCor().getProdutoGrade().getProduto().getIdentificador() + "-" + i.getGradeCor().getProdutoGrade().getProduto().getNome() + "\n";
        }
        if (TMethods.isStrWithData((String)erros)) {
            this.addError(this.code("V.ERP.0835.006", (String)erros), vo.getItemConfNFTerceiros());
        }
    }

    private Boolean conferirProduto(ConferenciaNFTerceiros vo, GradeCor gradeCor) {
        OpcoesCompraSuprimentos opcoesCompra = this.getSharedObjects().getOpcoesCompraSuprimentos(vo.getEmpresa());
        if (TMethods.isNotNull((Object)opcoesCompra).booleanValue() && !this.isEquals(opcoesCompra.getTipoConfNFTerceirosItens(), EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value)) {
            return true;
        }
        return this.isEquals(gradeCor.getProdutoGrade().getProduto().getTipoConfNFTerceirosProduto().getTipo(), EnumConstTipoConfNFProduto.CONFERIR.value);
    }

    @Override
    public String getSimpleName() {
        return "835 - Conferencia NF Terceiros";
    }
}

