/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.liberacaonfterceirosqualidade;

import com.touchcomp.basementor.constants.enums.confnfterceiros.EnumConstModFichaTecConfNFTerc;
import com.touchcomp.basementor.constants.enums.confnfterceiros.EnumConstTipoConfNFTercItens;
import com.touchcomp.basementor.constants.enums.relacionamentopessoa.EnumConstTipoConfNFProduto;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemInfAdicionalItemConfNFTerc;
import com.touchcomp.basementor.model.vo.ItemLiberacaoNFTerceirosQualidade;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosQualidade;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidLiberacaoNFTerceirosQualidade
extends ValidGenericEntitiesImpl<LiberacaoNFTerceirosQualidade> {
    @Override
    protected void isValid(LiberacaoNFTerceirosQualidade vo) {
        this.valid(this.code("V.ERP.1748.001", "liberacaoNota"), vo.getLiberacaoNota());
        if (vo.getLiberacaoNota() != null) {
            this.valid(this.code("V.ERP.1748.002", "notaTerceiros"), vo.getLiberacaoNota().getNotaTerceiros());
        }
        this.valid(this.code("V.ERP.1748.003", "usuario"), vo.getUsuario());
        if (vo.getEmpresa() != null) {
            OpcoesCompraSuprimentos opcoes = this.getSharedObjects().getOpcoesCompraSuprimentos(vo.getEmpresa());
            if (opcoes == null || !this.isAffirmative(opcoes.getUtilizarModeloFichaConfNFTerceiros())) {
                return;
            }
            this.validaObrigatoriedadeFichaTec(vo.getItensLiberacao(), opcoes);
        }
    }

    private void validaObrigatoriedadeFichaTec(List<ItemLiberacaoNFTerceirosQualidade> itens, OpcoesCompraSuprimentos opcoes) {
        Boolean cadastroCompleto = true;
        Integer count = 0;
        for (ItemLiberacaoNFTerceirosQualidade i : itens) {
            if (i.getInfAdicionalItemConfNFTerc() == null || i.getInfAdicionalItemConfNFTerc().getItemInfAdicionalItemConfNFe() == null || i.getInfAdicionalItemConfNFTerc().getModeloFicha() == null) {
                if (this.conferirProduto(i.getGradeCor(), opcoes).booleanValue()) {
                    cadastroCompleto = false;
                }
            } else {
                Integer n = count;
                count = count + 1;
            }
            if (this.isEquals(opcoes.getUtilizarModeloFichaConfNFTerceiros(), EnumConstModFichaTecConfNFTerc.INFORMAR_TODOS.getValue()) && !cadastroCompleto.booleanValue()) {
                this.newMessageItem(this.code("V.ERP.1748.004", ""), null);
            }
            if (i.getInfAdicionalItemConfNFTerc() == null) continue;
            this.validItensModeloFichaTecnica(i.getInfAdicionalItemConfNFTerc().getItemInfAdicionalItemConfNFe());
        }
        if (count == 0) {
            this.newMessageItem(this.code("V.ERP.1748.006", ""), null);
        }
    }

    private Boolean conferirProduto(GradeCor gradeCor, OpcoesCompraSuprimentos opcoes) {
        if (!ToolMethods.isEquals((Object)opcoes.getTipoConfNFTerceirosItens(), (Object)EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            return true;
        }
        return ToolMethods.isEquals((Object)gradeCor.getProdutoGrade().getProduto().getTipoConfNFTerceirosProduto().getTipo(), (Object)EnumConstTipoConfNFProduto.CONFERIR.getValue());
    }

    private void validItensModeloFichaTecnica(List<ItemInfAdicionalItemConfNFTerc> itens) {
        for (ItemInfAdicionalItemConfNFTerc i : itens) {
            if (!this.isAffirmative(i.getValorObrigatorio()) || i.getValor() != null) continue;
            this.newMessageItem(this.code("V.ERP.1748.005", i.getChave()), i.getValor());
        }
    }

    @Override
    public String getSimpleName() {
        return "Libera\u00e7\u00e3o Qualidade NFT";
    }
}

