/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.modelolancamentofinanceiro;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ItemModeloLancBancario;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ValidModeloLancBancario
extends ValidGenericEntitiesImpl<ModeloLancBancario> {
    @Override
    protected void isValid(ModeloLancBancario vo) {
        this.valid(this.code("V.ERP.0117.001", "nome"), vo.getNome());
        this.validNotEmpty(this.code("V.ERP.0117.002", "itemModeloLancBancario"), vo.getItemModeloLancBancario());
        this.valid(this.code("V.ERP.0117.003", "debCred"), vo.getTipoAplicacaoCredDeb());
        if (vo.getItemModeloLancBancario() != null) {
            for (ItemModeloLancBancario i : vo.getItemModeloLancBancario()) {
                this.valid(this.code("V.ERP.0117.004", "historicoPadrao"), i.getHistoricoPadrao());
                this.valid(this.code("V.ERP.0117.005", "debCred"), i.getDebCred());
                this.valid(this.code("V.ERP.0117.006", "planoContaGerencial"), i.getPlanoContaGerencial());
                if (!this.isEquals(vo.getNaoContabilizarMov(), EnumConstantsMentorSimNao.NAO.getValue())) continue;
                this.valid(this.code("V.ERP.0117.007", "planoConta"), i.getPlanoConta());
            }
            this.validPlanoConta(vo.getItemModeloLancBancario());
        }
    }

    private void validPlanoConta(List<ItemModeloLancBancario> itemModeloLancBancario) {
        String planoConta = itemModeloLancBancario.stream().filter(i -> ToolMethods.isNotNull((Object)i.getPlanoConta())).filter(i -> this.isEquals(i.getPlanoConta().getMarca().shortValue(), EnumConstSinteticoAnalitico.SINTETICO.getValue())).map(i -> i.getPlanoConta().toString()).distinct().collect(Collectors.joining(" , "));
        if (ToolMethods.isStrWithData((String)planoConta)) {
            this.addError(this.code("V.ERP.0117.008", planoConta), planoConta);
        }
    }

    @Override
    public String getSimpleName() {
        return "Modelo Lan\u00e7amento Financeiro";
    }
}

