/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.movimentobancario;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ValidMovimentoBancario
extends ValidGenericEntitiesImpl<MovimentoBancario> {
    @Override
    protected void isValid(MovimentoBancario vo) {
        this.valid(this.code("V.ERP.0356.001"), vo.getDataLancamento());
        this.valid(this.code("V.ERP.0356.002"), vo.getDataCompensacao());
        this.validBefore(this.code("V.ERP.0356.003"), vo.getDataLancamento(), vo.getDataCompensacao(), new Object[0]);
        this.valid(this.code("V.ERP.0356.004"), vo.getDebCred());
        this.valid(this.code("V.ERP.0356.005"), vo.getContaValor());
        this.valid(this.code("V.ERP.0356.006"), vo.getHistorico());
        this.valid(this.code("V.ERP.0356.007"), vo.getValor());
        if (ToolMethods.isNull((Object)vo.getGrupoDeBaixaFormas()).booleanValue() || ToolMethods.isNull((Object)vo.getTransferenciaValor()).booleanValue()) {
            this.valid(this.code("V.ERP.0356.008"), vo.getModeloLancamentoBancario());
        }
        this.validContrapartida(vo.getContraPartMovimentoBancario());
    }

    private void validContrapartida(List<ContraPartMovimentoBancario> contraPartMovimentoBancario) {
        if (ToolMethods.isWithData(contraPartMovimentoBancario)) {
            AtomicInteger counterSemBordero = new AtomicInteger(1);
            String idContrapartidaSemBordero = contraPartMovimentoBancario.stream().filter(contraPart -> this.isEquals(contraPart.getBuscaTitulos(), EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isNull((Object)contraPart.getBordero()) != false).map(contraPart -> ToolMethods.isNotNull((Object)contraPart.getIdentificador()) != false ? contraPart.getIdentificador().toString() : String.valueOf(counterSemBordero.getAndIncrement())).collect(Collectors.joining(","));
            if (ToolMethods.isStrWithData((String)idContrapartidaSemBordero)) {
                this.addError(this.code("V.ERP.0356.009", idContrapartidaSemBordero), idContrapartidaSemBordero);
            }
            AtomicInteger counterSemHistoricoPadrao = new AtomicInteger(1);
            String idContrapartidaSemHistoricoPadrao = contraPartMovimentoBancario.stream().filter(contraPart -> ToolMethods.isNull((Object)contraPart.getHistoricoPadrao())).map(contraPart -> ToolMethods.isNotNull((Object)contraPart.getIdentificador()) != false ? contraPart.getIdentificador().toString() : String.valueOf(counterSemHistoricoPadrao.getAndIncrement())).collect(Collectors.joining(","));
            if (ToolMethods.isStrWithData((String)idContrapartidaSemHistoricoPadrao)) {
                this.addError(this.code("V.ERP.0356.010", idContrapartidaSemHistoricoPadrao), idContrapartidaSemHistoricoPadrao);
            }
            AtomicInteger counterSemValor = new AtomicInteger(1);
            String idContrapartidaSemValor = contraPartMovimentoBancario.stream().filter(contraPart -> contraPart.getValor() <= 0.0).map(contraPart -> ToolMethods.isNotNull((Object)contraPart.getIdentificador()) != false ? contraPart.getIdentificador().toString() : String.valueOf(counterSemValor.getAndIncrement())).collect(Collectors.joining(","));
            if (ToolMethods.isStrWithData((String)idContrapartidaSemValor)) {
                this.addError(this.code("V.ERP.0356.011", idContrapartidaSemValor), idContrapartidaSemValor);
            }
            AtomicInteger counterSemHistorico = new AtomicInteger(1);
            String idContrapartidaSemHistorico = contraPartMovimentoBancario.stream().filter(contraPart -> !ToolMethods.isStrWithData((String)contraPart.getHistorico())).map(contraPart -> ToolMethods.isNotNull((Object)contraPart.getIdentificador()) != false ? contraPart.getIdentificador().toString() : String.valueOf(counterSemHistorico.getAndIncrement())).collect(Collectors.joining(","));
            if (ToolMethods.isStrWithData((String)idContrapartidaSemHistorico)) {
                this.addError(this.code("V.ERP.0356.012", idContrapartidaSemHistorico), idContrapartidaSemHistorico);
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }
}

