/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.necessidadecompra;

import com.touchcomp.basementor.model.vo.EmailGrupoNecCompra;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.others.email.ValidateEmail;
import org.springframework.stereotype.Component;

@Component
public class ValidNecessidadeCompra
extends ValidGenericEntitiesImpl<NecessidadeCompra> {
    @Override
    protected void isValid(NecessidadeCompra vo) {
        this.valid(this.code("V.ERP.1064.001", "aquisicaoPreferencial"), vo.getAquisicaoPreferencial());
        this.valid(this.code("V.ERP.1064.003", "centroCusto"), vo.getCentroCusto());
        this.valid(this.code("V.ERP.1064.004", "dataNecessidade"), vo.getDataNecessidade());
        this.valid(this.code("V.ERP.1064.005", "desativarNecessidade"), vo.getDesativarNecessidade());
        if (this.isAffirmative(vo.getDesativarNecessidade())) {
            this.valid(this.code("V.ERP.1064.006", "motivoDesativacao"), vo.getMotivoDesativacao());
        }
        this.valid(this.code("V.ERP.1064.007", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.1064.008", "gradeCor"), vo.getGradeCor());
        this.validGreather0(this.code("V.ERP.1064.009", "quantidadeNecessidade"), vo.getQuantidadeNecessidade());
        this.valid(this.code("V.ERP.1064.010", "tipoGeracao"), vo.getTipoGeracao());
        this.valid(this.code("V.ERP.1064.011", "tipoNecessidade"), vo.getTipoNecessidade());
        this.valid(this.code("V.ERP.1064.014", "naturezaOperacao"), vo.getNaturezaOperacao());
        if (this.isAffirmative(vo.getAquisicaoPreferencial())) {
            this.valid(this.code("V.ERP.1064.012", "motivoAquisicaoPreferencial"), vo.getMotivoAquisicaoPreferencial());
            this.valid(this.code("V.ERP.1064.013", "unidadeFatFornecedor"), vo.getUnidadeFatFornecedor());
            this.valid(this.code("V.ERP.1064.015", "tipoFrete"), vo.getTipoFrete());
            this.valid(this.code("V.ERP.1064.016", "condicoesPagamento"), vo.getCondicoesPagamento());
            this.validGreather0(this.code("V.ERP.1064.017", "valor"), vo.getValor());
            this.valid(this.code("V.ERP.1064.019", "prazoEntrega"), vo.getPrazoEntrega());
            this.valid(this.code("V.ERP.1064.020", "dataPrevFaturamento"), vo.getDataPrevFaturamento());
            if (vo.getCondicoesPagamento() != null && this.isAffirmative(vo.getCondicoesPagamento().getCondMutante()) && !this.isAffirmative(vo.getCondicoesPagamento().getMutanteFixa())) {
                this.valid(this.code("V.ERP.1064.021", "condicaoMutante"), vo.getCondicaoMutante());
            }
        }
        this.validarEmails(vo);
    }

    private void validarEmails(NecessidadeCompra vo) {
        if (vo.getEmailGrupoNecCompra() == null || vo.getEmailGrupoNecCompra().isEmpty()) {
            return;
        }
        for (EmailGrupoNecCompra e : vo.getEmailGrupoNecCompra()) {
            this.valid(this.code("V.ERP.1064.022", "email"), e.getEmail());
            if (e.getEmail() == null || ValidateEmail.isValid(e.getEmail())) continue;
            this.addError(this.code("V.ERP.1064.023", "email", e.getEmail()), e.getEmail());
        }
    }

    @Override
    public String getSimpleName() {
        return NecessidadeCompra.class.getSimpleName();
    }
}

