/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.opcoescontabeisbaixatitulos;

import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.TipoValoresTitulosOpcoesCtbBaixaTit;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidOpcoesContabeisBaixaTitulos
extends ValidGenericEntitiesImpl<OpcoesContabeisBaixaTitulos> {
    @Override
    protected void isValid(OpcoesContabeisBaixaTitulos vo) {
        this.validNotEmpty(this.code("V.ERP.0650.001", "tipoValoresTitulosOpcoesCtbBaixaTit"), vo.getTipoValoresTitulosOpcoesCtbBaixaTit());
        this.valid(this.code("V.ERP.0650.002", "pagRec"), vo.getPagRec());
        if (vo.getCentroCustoLiquidacao() != null) {
            if (!this.isAffirmative(vo.getCentroCustoLiquidacao().getMarca())) {
                this.addError(this.code("V.ERP.0650.003", "centroCustoLiquidacao"), vo.getCentroCustoLiquidacao());
            }
            if (vo.getCentroCustoLiquidacao().getCentroCustoEmpresa() != null) {
                if (!vo.getCentroCustoLiquidacao().getCentroCustoEmpresa().stream().anyMatch(ce -> this.isEquals(ce.getEmpresa(), vo.getEmpresa()))) {
                    this.addError(this.code("V.ERP.0650.004", "centroCustoLiquidacao"), vo.getCentroCustoLiquidacao());
                }
            } else {
                this.addError(this.code("V.ERP.0650.004", "centroCustoLiquidacao"), vo.getCentroCustoLiquidacao());
            }
        }
        if (TMethods.isWithData((Collection)vo.getTipoValoresTitulosOpcoesCtbBaixaTit())) {
            this.valid(this.code("V.ERP.0650.005", "pcDebRepasse"), vo.getPcDebRepasse());
            this.valid(this.code("V.ERP.0650.006", "pcCredRepasse"), vo.getPcCredRepasse());
        }
        if (!this.isEquals(vo.getPagRec(), EnumConstTipoTitulo.AMBOS.getValue()) && TMethods.isWithData((Collection)vo.getTipoValoresTitulosOpcoesCtbBaixaTit())) {
            for (TipoValoresTitulosOpcoesCtbBaixaTit tv : vo.getTipoValoresTitulosOpcoesCtbBaixaTit()) {
                if (this.isEquals(vo.getPagRec(), tv.getTipoValoresTitulos().getTipoDoc())) continue;
                this.addError(this.code("V.ERP.0650.007", "tipoValores", tv.getTipoValoresTitulos().getDescricao()), vo.getCentroCustoLiquidacao());
            }
        }
        if (!(this.isAffirmative(vo.getFormaPagamentoFaltaPagamento()) || this.isAffirmative(vo.getFormaPagamentoContaValor()) || this.isAffirmative(vo.getFormaPagamentoDevolucao()) || this.isAffirmative(vo.getFormaPagamentoCartaoDebito()) || this.isAffirmative(vo.getFormaPagamentoCheque()) || this.isAffirmative(vo.getFormaPagamentoCompensacaoTitulos()) || this.isAffirmative(vo.getFormaPagamentoChequeTerceiros()) || this.isAffirmative(vo.getFormaPagamentoBorderoCobranca()) || this.isAffirmative(vo.getFormaPagamentoCartaoCredito()))) {
            this.addError(this.code("V.ERP.0650.008", "formaPagamento"), vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "650 - Op\u00e7\u00f5es Cont\u00e1beis para Baixa T\u00edtulos";
    }
}

