/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.opcoesfaturamentotransporte;

import com.touchcomp.basementor.model.vo.OpcoesFatTranspAutDownXML;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTransp;
import com.touchcomp.basementor.model.vo.OpcoesRelacTransporte;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import org.springframework.stereotype.Component;

@Component
public class ValidOpcoesFaturamentoTransp
extends ValidGenericEntitiesImpl<OpcoesFaturamentoTransp> {
    @Override
    protected void isValid(OpcoesFaturamentoTransp entity) {
        this.valid(this.code("V.ERP.0483.001", "tipoOperacaoCteImpCTe"), entity.getTipoOperacaoCteImpCTe());
        this.valid(this.code("V.ERP.0483.002", "tipoOperacaoCteImpNFe"), entity.getTipoOperacaoCteImpNFe());
        this.valid(this.code("V.ERP.0483.003", "tipoConjuntoTransportador"), entity.getTipoConjuntoTransportador());
        this.valid(this.code("V.ERP.0483.004", "tipoAmbiente"), entity.getTipoAmbiente());
        this.valid(this.code("V.ERP.0483.005", "tipoImpressao"), entity.getTipoImpressao());
        this.valid(this.code("V.ERP.0483.006", "tipoDocPagtoTranspAgregado"), entity.getTipoDocPagtoTranspAgregado());
        this.valid(this.code("V.ERP.0483.007", "carteiraCobrancaPgtoTranspAgregado"), entity.getCarteiraCobrancaPgtoTranspAgregado());
        this.valid(this.code("V.ERP.0483.008", "centroCustPagtoTransAgregado"), entity.getCentroCustPagtoTransAgregado());
        if (this.isAffirmative(entity.getGerarTipoOperUnificado())) {
            this.valid(this.code("V.ERP.0483.009", "tipoOperacaoFrete"), entity.getTipoOperacaoFrete());
        }
        this.valid(this.code("V.ERP.0483.010", "categoriaPessoa"), entity.getCategoriaPessoa());
        if (this.isAffirmative(entity.getImportarPesoXMLNFe())) {
            this.valid(this.code("V.ERP.0483.011", "tipoMedidaCargaCte"), entity.getTipoMedidaCargaCte());
        }
        if (entity.getOpcoesRelacTransporte() != null) {
            OpcoesRelacTransporte op = entity.getOpcoesRelacTransporte();
            if (this.isAffirmative(op.getEnviarEmailDestFat()) || this.isAffirmative(op.getEnviarEmailExpFat()) || this.isAffirmative(op.getEnviarEmailRecFat()) || this.isAffirmative(op.getEnviarEmailRemFat()) || this.isAffirmative(op.getEnviarEmailTomFat()) || this.isAffirmative(op.getEnviarEmailTranspAgregadoFat())) {
                this.valid(this.code("V.ERP.0483.012", "servidorEmail"), op.getServidorEmail());
                this.valid(this.code("V.ERP.0483.013", "modeloEmailFat"), op.getModeloEmailFat());
            }
            if (this.isAffirmative(op.getEnviarEmailDestCanc()) || this.isAffirmative(op.getEnviarEmailExpCanc()) || this.isAffirmative(op.getEnviarEmailRecCanc()) || this.isAffirmative(op.getEnviarEmailRemCanc()) || this.isAffirmative(op.getEnviarEmailTomCanc()) || this.isAffirmative(op.getEnviarEmailTranspAgregadoCanc())) {
                this.valid(this.code("V.ERP.0483.012", "servidorEmail"), op.getServidorEmail());
                this.valid(this.code("V.ERP.0483.013", "modeloEmailFat"), op.getModeloEmailFat());
            }
            if (this.isAffirmative(op.getEnviarCopiaEmailFat())) {
                this.valid(this.code("V.ERP.0483.015", "emailCopia"), op.getEmailCopia());
            }
        }
        if (entity.getOpcoesFatDownloadXMLCTe() != null) {
            for (OpcoesFatTranspAutDownXML op : entity.getOpcoesFatDownloadXMLCTe()) {
                if (ValidadeCPFCNPJ.isValid(op.getCnpjCPF())) continue;
                this.addError(this.code("V.ERP.0483.014", new Object[]{op.getCnpjCPF()}), op.getCnpjCPF());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "483 - Op\u00e7\u00f5es Faturamento Transporte";
    }
}

