/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.opcoesmanutencequip;

import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidOpcoesManutencEquip
extends ValidGenericEntitiesImpl<OpcoesManutencEquip> {
    @Override
    protected void isValid(OpcoesManutencEquip vo) {
        if (this.isEquals(vo.getGerarNovaOS(), EnumConstantsSimNao.SIM.getValue()) && !this.isAffirmative(vo.getDiasNovaOS())) {
            this.addError(this.code("V.ERP.0787.001"), vo.getDiasNovaOS());
        }
        if (this.isEquals(vo.getGerarLancGerFechamOsExecutante(), EnumConstantsSimNao.SIM.getValue()) && ToolMethods.isNull((Object)vo.getPlanoContaGerFechamentoOsExecutante()).booleanValue()) {
            this.addError(this.code("V.ERP.0787.002"), vo.getPlanoContaGerFechamentoOsExecutante());
        }
        this.valid(this.code("V.ERP.0787.003", "tipoPrecoConsumo"), vo.getTipoPrecoConsumo());
        this.valid(this.code("V.ERP.0787.004", "centroEstoque"), vo.getCentroEstoque());
        this.valid(this.code("V.ERP.0787.005", "centroEstoqueReserva"), vo.getCentroEstoqueReserva());
        if (!this.validarMascara(vo.getMascaraCodigoAtivo()).booleanValue()) {
            this.addError(this.code("V.ERP.0787.006"), vo.getMascaraCodigoAtivo());
        }
    }

    private Boolean validarMascara(String text) {
        if (text != null && text.length() > 0) {
            for (int i = 0; i < text.length(); ++i) {
                if (!Character.isLetter(text.charAt(i)) || text.charAt(i) == 'l' || text.charAt(i) == 'L' || text.charAt(i) == 'n' || text.charAt(i) == 'N') continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getSimpleName() {
        return "787 - Op\u00e7\u00f5es Manuten\u00e7\u00e3o Ativos";
    }
}

