/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.pedido;

import com.touchcomp.basementor.constants.enums.pedido.EnumConstGeracaoTitulosPreVendaPedido;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.endereco.ValidEndereco;
import com.touchcomp.basementorvalidator.entities.impl.pedido.ValidItemPedido;
import java.util.Collection;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Primary
@Component
@Scope(value="prototype")
public class ValidPedido
extends ValidGenericEntitiesImpl<Pedido> {
    ValidEndereco validEnd = new ValidEndereco();
    ValidItemPedido validItem = new ValidItemPedido();
    private Usuario usuario;
    private boolean naoValidarPagamentos;

    @Override
    public void clearContainer() {
        super.clearContainer();
        this.validEnd.clearContainer();
        this.validItem.clearContainer();
    }

    @Override
    public void onGetBean() {
        this.usuario = null;
        this.naoValidarPagamentos = false;
    }

    @Override
    protected void isValid(Pedido vo) {
        Integer nrItens;
        this.valid(this.code("V.ERP.1180.001"), vo.getDataPrevisaoSaida());
        this.valid(this.code("V.ERP.1180.002"), vo.getDataPrevisaoFat());
        this.valid(this.code("V.ERP.1180.003"), vo.getDataEmissao());
        if (this.valid(this.code("V.ERP.1180.004"), vo.getUnidadeFatCliente()) && vo.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf().getSigla().equalsIgnoreCase("EX") && (vo.getUfEmbarque() == null || vo.getLocalEmbarque() == null || vo.getLocalEmbarque().trim().length() <= 0)) {
            this.addError(this.code("V.ERP.1180.016"), vo);
        }
        this.valid(this.code("V.ERP.1180.005"), vo.getRepresentante());
        if (this.valid(this.code("V.ERP.1180.006"), vo.getTransportador()) && !this.transportadorAtendePraca(vo.getTransportador(), vo.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf()).booleanValue()) {
            this.addError(this.code("V.ERP.1180.007"), vo);
        }
        this.valid(this.code("V.ERP.1180.008"), vo.getTipoFrete());
        this.valid(this.code("V.ERP.1180.043"), vo.getObservacao());
        if (this.valid(this.code("V.ERP.1180.009"), vo.getSituacaoPedido()) && this.isEquals(vo.getSituacaoPedido().getCancelarTitulos(), (short)1)) {
            this.valid(this.code("V.ERP.1180.010"), vo.getMotivoCancelamento());
        }
        this.valid(this.code("V.ERP.1180.011"), vo.getMeioPagamento());
        if (this.valid(this.code("V.ERP.1180.012"), vo.getCondicoesPagamento()) && TMethods.isAffirmative((Number)vo.getCondicoesPagamento().getCondMutante())) {
            this.valid(this.code("V.ERP.1180.013"), vo.getCondPagMut());
        }
        if (vo.getUfEmbarque() != null && (vo.getLocalEmbarque() == null || vo.getLocalEmbarque().trim().length() <= 0)) {
            this.valid(this.code("V.ERP.1180.014"), vo.getUfEmbarque());
        }
        if (vo.getUfEmbarque() == null && vo.getLocalEmbarque() != null && vo.getLocalEmbarque().trim().length() > 0) {
            this.valid(this.code("V.ERP.1180.015"), vo.getLocalEmbarque());
        }
        Double percDescontoTotal = ToolFormatter.arrredondarNumero((Double)vo.getPercDesconto(), (int)4);
        Double percDescontoTrib = ToolFormatter.arrredondarNumero((Double)vo.getPercDescontoTrib(), (int)4);
        if (this.usuario != null && ToolFormatter.arrredondarNumero((Double)(percDescontoTotal - percDescontoTrib), (int)4) > ToolFormatter.arrredondarNumero((Double)this.usuario.getUsuarioConfiguracoes().getPercDescontoPedido(), (int)4)) {
            this.addError(this.code("V.ERP.1180.017", ToolFormatter.formataNumero((Number)(percDescontoTotal - percDescontoTrib), (int)4), ToolFormatter.formataNumero((Number)(percDescontoTotal - percDescontoTrib), (int)4), ToolFormatter.formataNumero((Number)this.usuario.getUsuarioConfiguracoes().getPercDescontoPedido(), (int)4)), vo);
        }
        this.valid(this.code("V.ERP.1180.018"), (Object)vo.getItemPedido());
        if (vo.getPercDescFinanceiro() != null && vo.getPercDescFinanceiro() >= 100.0) {
            this.addError(this.code("V.ERP.1180.019"), vo);
        }
        this.valid(this.code("V.ERP.1180.020"), vo.getMoeda());
        this.valid(this.code("V.ERP.1180.021"), vo.getIndicadorPresencaConsumidor());
        this.validarInfPagPedido(vo);
        if (vo.getCotacaoMoeda() != null && !vo.getCotacaoMoeda().getMoeda().getIdentificador().equals(vo.getMoeda().getIdentificador())) {
            this.addError(this.code("V.ERP.1180.022"), vo);
        }
        if (!this.isEquals(nrItens = Integer.valueOf(vo.getItemPedido().size()), vo.getNrTotalItens())) {
            this.addError(this.code("V.ERP.1180.023"), vo);
        }
        if (TMethods.isAffirmative((Number)vo.getInformarLocalEntrega())) {
            this.valid((ValidGenericEntitiesImpl)this.validEnd, (InterfaceVO)vo.getEnderecoEntrega());
        }
        this.validarItens(vo);
        this.validarReceiturarioPedido(vo);
    }

    private Boolean transportadorAtendePraca(Transportador transportador, UnidadeFederativa ufCliente) {
        if (!ToolMethods.isWithData((Collection)transportador.getPraca())) {
            return false;
        }
        return transportador.getPraca().stream().anyMatch(praca -> this.isEquals(praca.getUf(), ufCliente));
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validarInfPagPedido(Pedido vo) {
        if (vo.getInfPagamentoPedido() == null) {
            return;
        }
        if (this.naoValidarPagamentos) {
            return;
        }
        if (vo.getSituacaoPedido() != null && this.isAffirmative(vo.getSituacaoPedido().getCancelarTitulos())) {
            return;
        }
        boolean achou = false;
        boolean achouTit = false;
        double totPag = 0.0;
        double totalPedido = 0.0;
        for (ItemPedido item : vo.getItemPedido()) {
            if (item.getModeloFiscal() == null || !item.getModeloFiscal().getGerarFinanceiro().equals((short)1)) continue;
            if (item.getValorTotalComImpostos() > 0.0) {
                totalPedido += item.getValorTotalComImpostos().doubleValue();
                continue;
            }
            totalPedido += item.getValorTotal().doubleValue();
        }
        for (InfPagamentoPedido infPag : vo.getInfPagamentoPedido()) {
            CondicoesPagamento cond = infPag.getCondicoesPagamento();
            if (this.valid(this.code("V.ERP.1180.012"), vo.getCondicoesPagamento()) && TMethods.isAffirmative((Number)vo.getCondicoesPagamento().getCondMutante())) {
                this.valid(this.code("V.ERP.1180.013"), vo.getCondPagMut());
            }
            this.validGreather0(this.code("V.ERP.1180.041", infPag.getCondicoesPagamento()), infPag.getValorLiquido());
            this.valid(this.code("V.ERP.1180.042", infPag.getCondicoesPagamento()), (Object)infPag.getTitulos());
            if (cond != null && cond.getValorMinimoVenda() > 0.0 && cond.getValorMinimoVenda() > infPag.getValor()) {
                this.addError(this.code("V.ERP.1180.024", infPag.getCondicoesPagamento()), vo);
            }
            if (ToolMethods.isWithData((Number)vo.getPercDescontoInf()) && vo.getPercDescontoInf() > infPag.getCondicoesPagamento().getPercentualMaximoDesconto()) {
                this.addError(this.code("V.ERP.1180.044", infPag.getCondicoesPagamento()), vo);
            }
            if (vo.getSituacaoPedido() != null && this.isAffirmative(vo.getSituacaoPedido().getNaoGerarTitulosPedido()) || ToolMethods.isEquals((Object)vo.getSituacaoPedido().getGerarFinanceiroNFCe(), (Object)EnumConstGeracaoTitulosPreVendaPedido.NAO_GERAR_TITULOS.getValue())) continue;
            double totTitulos = 0.0;
            for (Titulo tit : infPag.getTitulos()) {
                if (cond != null && cond.getValorMinimoParcela() > 0.0 && cond.getValorMinimoParcela() > tit.getValor()) {
                    this.addError(this.code("V.ERP.1180.025", infPag.getCondicoesPagamento()), vo);
                }
                if (!this.isEquals(infPag.getCondicoesPagamento(), vo.getCondicoesPagamento())) {
                    achou = true;
                }
                if (!this.isEquals(tit.getPessoa(), vo.getUnidadeFatCliente().getCliente().getPessoa())) {
                    achouTit = true;
                }
                totTitulos += tit.getValor().doubleValue();
            }
            if (achouTit && vo.getUnidadeFatCliente() != null) {
                this.addError(this.code("V.ERP.1180.027", vo.getUnidadeFatCliente().getCliente()), vo);
            }
            if (ToolFormatter.arrredondarNumero((Double)totTitulos, (int)2) - ToolFormatter.arrredondarNumero((Double)infPag.getValorLiquido(), (int)2) != 0.0) {
                this.addError(this.code("V.ERP.1180.045", infPag.getCondicoesPagamento()), vo);
            }
            totPag += infPag.getValor().doubleValue();
        }
        if (!(vo.getSituacaoPedido() != null && this.isAffirmative(vo.getSituacaoPedido().getNaoGerarTitulosPedido()) && this.isEquals(vo.getSituacaoPedido().getGerarFinanceiroNFCe(), EnumConstGeracaoTitulosPreVendaPedido.NAO_GERAR_TITULOS.getValue()) || ToolFormatter.arrredondarNumero((Double)totPag, (int)2) - ToolFormatter.arrredondarNumero((Double)totalPedido, (int)2) == 0.0)) {
            this.addError(this.code("V.ERP.1180.046", vo), vo);
        }
    }

    private void validarReceiturarioPedido(Pedido vo) {
        if (vo.getItemPedido() != null) {
            Integer totalItensComReceita = 0;
            for (ItemPedido ip : vo.getItemPedido()) {
                if (!this.isAffirmative(ip.getProduto().getEmitirReceitaAgro())) continue;
                Integer n = totalItensComReceita;
                totalItensComReceita = totalItensComReceita + 1;
            }
            if (totalItensComReceita > 3) {
                this.addError(this.code("V.ERP.1180.065", vo), vo);
            }
        }
    }

    private void validarItens(Pedido vo) {
        this.validItem.setOpcoesFaturamento(this.getSharedObjects().getOpcoesFaturamento(vo.getEmpresa()));
        this.valid((ValidGenericEntitiesImpl)this.validItem, vo.getItemPedido());
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public void setNaoValidarPagamentos(boolean validarPag) {
        this.naoValidarPagamentos = validarPag;
    }
}

